/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data;

import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.session.Command;
import org.geotools.arcsde.session.ISession;
import org.geotools.arcsde.session.ISessionPool;
import org.geotools.arcsde.session.SessionWrapper;
import org.geotools.arcsde.session.UnavailableConnectionException;
import org.geotools.data.DataSourceException;
import org.geotools.data.Transaction;
import org.geotools.util.logging.Logging;

final class SessionTransactionState
implements Transaction.State {
    private static final Logger LOGGER = Logging.getLogger((String)SessionTransactionState.class.getPackage().getName());
    private TransactionSession session;
    private Transaction transaction;

    private SessionTransactionState(ISession session) {
        if (!session.isTransactionActive()) {
            throw new IllegalArgumentException("session shall be in transactional mode");
        }
        this.session = new TransactionSession(session);
    }

    public void commit() throws IOException {
        this.failIfClosed();
        TransactionSession session = this.session;
        Command<Void> commitCommand = new Command<Void>(){

            @Override
            public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
                try {
                    session.commitTransaction();
                    session.startTransaction();
                }
                catch (IOException se) {
                    LOGGER.log(Level.WARNING, se.getMessage(), se);
                    throw se;
                }
                return null;
            }
        };
        session.issue(commitCommand);
    }

    public void rollback() throws IOException {
        this.failIfClosed();
        TransactionSession session = this.session;
        try {
            session.issue(new Command<Void>(){

                @Override
                public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
                    session.rollbackTransaction();
                    session.startTransaction();
                    return null;
                }
            });
        }
        catch (IOException se) {
            this.close();
            LOGGER.log(Level.WARNING, se.getMessage(), se);
            throw se;
        }
    }

    public void addAuthorization(String authId) {
    }

    public void setTransaction(Transaction transaction) {
        if (Transaction.AUTO_COMMIT.equals(transaction)) {
            throw new IllegalArgumentException("Cannot use Transaction.AUTO_COMMIT here");
        }
        if (transaction == null) {
            this.close();
        } else if (this.transaction != null) {
            throw new IllegalStateException("Once a transaction is set, it is illegal to call Transaction.State.setTransaction with anything other than null: " + transaction);
        }
        this.transaction = transaction;
    }

    private void failIfClosed() throws IllegalStateException {
        if (this.session == null) {
            throw new IllegalStateException("This transaction state has already been closed");
        }
    }

    private void close() {
        if (this.session == null) {
            return;
        }
        try {
            try {
                this.session.rollbackTransaction();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Unexpected exception at close(): " + e.getMessage(), e);
            }
            this.session.dispose();
        }
        catch (IllegalStateException workflowError) {
            try {
                this.session.rollbackTransaction();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "rolling back connection " + this.session, e);
                this.session.dispose();
            }
            throw workflowError;
        }
        finally {
            this.session = null;
        }
    }

    ISession getConnection() {
        this.failIfClosed();
        return this.session;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionTransactionState getState(Transaction transaction, ISessionPool pool) throws IOException {
        if (transaction == Transaction.AUTO_COMMIT) {
            LOGGER.log(Level.SEVERE, "Should not request ArcTransactionState when using AUTO_COMMITback connection");
            return null;
        }
        Class<SessionTransactionState> clazz = SessionTransactionState.class;
        synchronized (SessionTransactionState.class) {
            SessionTransactionState state = (SessionTransactionState)transaction.getState((Object)pool);
            if (state == null) {
                ISession session;
                try {
                    session = pool.getSession(true);
                }
                catch (UnavailableConnectionException e) {
                    throw new RuntimeException("Can't create a transaction state, connection pool exhausted", e);
                }
                try {
                    session.startTransaction();
                }
                catch (IOException e) {
                    try {
                        session.rollbackTransaction();
                    }
                    finally {
                        session.dispose();
                    }
                    throw new DataSourceException("Exception initiating transaction on " + session, (Throwable)e);
                }
                state = new SessionTransactionState(session);
                transaction.putState((Object)pool, (Transaction.State)state);
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return state;
        }
    }

    private static final class TransactionSession
    extends SessionWrapper {
        public TransactionSession(ISession session) {
            super(session);
        }

        @Override
        public void dispose() throws IllegalStateException {
            if (this.isTransactionActive()) {
                LOGGER.finer("Ignoring Session.close, transaction is active...");
            } else {
                this.wrapped.dispose();
            }
        }
    }
}

