/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.arcsde.data.ArcSdeFeatureWriter;
import org.geotools.arcsde.data.FIDReader;
import org.geotools.arcsde.session.ISession;
import org.geotools.arcsde.versioning.ArcSdeVersionHandler;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListenerManager;
import org.geotools.data.FeatureReader;
import org.geotools.data.Transaction;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

class AutoCommitFeatureWriter
extends ArcSdeFeatureWriter {
    public AutoCommitFeatureWriter(FIDReader fidReader, SimpleFeatureType featureType, FeatureReader<SimpleFeatureType, SimpleFeature> filteredContent, ISession session, FeatureListenerManager listenerManager, ArcSdeVersionHandler versionHandler) throws NoSuchElementException, IOException {
        super(fidReader, featureType, filteredContent, session, listenerManager, versionHandler);
    }

    @Override
    protected void doFireFeaturesAdded(String typeName, ReferencedEnvelope bounds, Filter filter) {
        FeatureEvent event = new FeatureEvent((Object)this, FeatureEvent.Type.ADDED, bounds, filter);
        this.listenerManager.fireEvent(typeName, Transaction.AUTO_COMMIT, event);
    }

    @Override
    protected void doFireFeaturesChanged(String typeName, ReferencedEnvelope bounds, Filter filter) {
        FeatureEvent event = new FeatureEvent((Object)this, FeatureEvent.Type.CHANGED, bounds, filter);
        this.listenerManager.fireEvent(typeName, Transaction.AUTO_COMMIT, event);
    }

    @Override
    protected void doFireFeaturesRemoved(String typeName, ReferencedEnvelope bounds, Filter filter) {
        FeatureEvent event = new FeatureEvent((Object)this, FeatureEvent.Type.REMOVED, bounds, filter);
        this.listenerManager.fireEvent(typeName, Transaction.AUTO_COMMIT, event);
    }
}

