/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.db2;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import org.geotools.data.db2.DB2DialectInfo;
import org.geotools.data.db2.DB2FilterToSQL;
import org.geotools.data.db2.DB2SQLDialect;
import org.geotools.data.db2.DB2Util;
import org.geotools.data.db2.DB2WKBWriter;
import org.geotools.factory.Hints;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DB2SQLDialectPrepared
extends PreparedStatementSQLDialect {
    private DB2SQLDialect delegate = null;

    public DB2SQLDialectPrepared(JDBCDataStore dataStore, DB2DialectInfo info) {
        super(dataStore);
        this.delegate = new DB2SQLDialect(dataStore, info);
    }

    @Override
    public CoordinateReferenceSystem createCRS(int srid, Connection cx) throws SQLException {
        return this.delegate.createCRS(srid, cx);
    }

    @Override
    public PreparedFilterToSQL createPreparedFilterToSQL() {
        DB2FilterToSQL filter = new DB2FilterToSQL(this);
        filter.setFunctionEncodingEnabled(this.isFunctionEncodingEnabled());
        filter.setLooseBBOXEnabled(this.delegate.isLooseBBOXEnabled());
        return filter;
    }

    public boolean isLooseBBOXEnabled() {
        return this.delegate.isLooseBBOXEnabled();
    }

    public void setLooseBBOXEnabled(boolean looseBBOXEnabled) {
        this.delegate.setLooseBBOXEnabled(looseBBOXEnabled);
    }

    @Override
    public void encodePrimaryKey(String column, StringBuffer sql) {
        this.delegate.encodePrimaryKey(column, sql);
    }

    @Override
    public String getGeometryTypeName(Integer type) {
        return this.delegate.getGeometryTypeName(type);
    }

    @Override
    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return this.delegate.getGeometrySRID(schemaName, tableName, columnName, cx);
    }

    public void encodeGeometryColumn(GeometryDescriptor gatt, StringBuffer sql) {
        this.delegate.encodeGeometryColumn(gatt, null, sql);
    }

    @Override
    public void encodeGeometryColumn(GeometryDescriptor gatt, String prefix, int srid, StringBuffer sql) {
        this.delegate.encodeGeometryColumn(gatt, prefix, srid, sql);
    }

    @Override
    public void encodeGeometryColumn(GeometryDescriptor gatt, String prefix, int srid, Hints hints, StringBuffer sql) {
        this.delegate.encodeGeometryColumn(gatt, prefix, srid, hints, sql);
    }

    @Override
    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        this.delegate.encodeGeometryEnvelope(tableName, geometryColumn, sql);
    }

    @Override
    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        return this.delegate.decodeGeometryEnvelope(rs, column, cx);
    }

    @Override
    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String name, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        return this.delegate.decodeGeometryValue(descriptor, rs, name, factory, cx);
    }

    @Override
    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, int column, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        return this.delegate.decodeGeometryValue(descriptor, rs, column, factory, cx);
    }

    @Override
    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        this.delegate.registerClassToSqlMappings(mappings);
    }

    @Override
    public void registerSqlTypeToClassMappings(Map<Integer, Class<?>> mappings) {
        this.delegate.registerSqlTypeToClassMappings(mappings);
    }

    @Override
    public void registerSqlTypeNameToClassMappings(Map<String, Class<?>> mappings) {
        this.delegate.registerSqlTypeNameToClassMappings(mappings);
    }

    @Override
    public void prepareFunctionArgument(Class clazz, StringBuffer sql) {
        String castExpression = DB2Util.getCastExpression(clazz);
        if (castExpression != null) {
            sql.append(castExpression);
        } else {
            super.prepareFunctionArgument(clazz, sql);
        }
    }

    @Override
    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        this.delegate.postCreateTable(schemaName, featureType, cx);
    }

    @Override
    public void setGeometryValue(Geometry g, int srid, Class binding, PreparedStatement ps, int column) throws SQLException {
        if (g == null || g.isEmpty()) {
            ps.setBytes(column, null);
            return;
        }
        DB2WKBWriter w = new DB2WKBWriter(DB2WKBWriter.guessCoorinateDims(g), this.getDb2DialectInfo().isHasOGCWkbZTyps());
        byte[] bytes = w.write(g);
        ps.setBytes(column, bytes);
    }

    @Override
    public String getSequenceForColumn(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return this.delegate.getSequenceForColumn(schemaName, tableName, columnName, cx);
    }

    @Override
    public Object getNextSequenceValue(String schemaName, String sequenceName, Connection cx) throws SQLException {
        return this.delegate.getNextSequenceValue(schemaName, sequenceName, cx);
    }

    @Override
    public boolean lookupGeneratedValuesPostInsert() {
        return this.delegate.lookupGeneratedValuesPostInsert();
    }

    @Override
    public Object getLastAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return this.delegate.getLastAutoGeneratedValue(schemaName, tableName, columnName, cx);
    }

    @Override
    public void prepareGeometryValue(Geometry geom, int srid, Class binding, StringBuffer sql) {
        DB2Util.prepareGeometryValue(geom, srid, binding, sql);
    }

    @Override
    public boolean isLimitOffsetSupported() {
        return this.delegate.isLimitOffsetSupported();
    }

    @Override
    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        this.delegate.applyLimitOffset(sql, limit, offset);
    }

    @Override
    public void encodeGeometryColumnGeneralized(GeometryDescriptor gatt, String prefix, int srid, StringBuffer sql, Double distance) {
        this.delegate.encodeGeometryColumnGeneralized(gatt, prefix, srid, sql, distance);
    }

    @Override
    protected void addSupportedHints(Set<Hints.Key> hints) {
        this.delegate.addSupportedHints(hints);
    }

    @Override
    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        return this.delegate.includeTable(schemaName, tableName, cx);
    }

    public DB2DialectInfo getDb2DialectInfo() {
        return this.delegate.getDb2DialectInfo();
    }

    public boolean isFunctionEncodingEnabled() {
        return this.delegate.isFunctionEncodingEnabled();
    }

    public void setFunctionEncodingEnabled(boolean functionEncodingEnabled) {
        this.delegate.setFunctionEncodingEnabled(functionEncodingEnabled);
    }
}

