/*
 * Decompiled with CFR 0.152.
 */
package org.tcat.citd.sim.udig.bookmarks.internal.ui;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.ViewPart;
import org.tcat.citd.sim.udig.bookmarks.Bookmark;
import org.tcat.citd.sim.udig.bookmarks.internal.BookmarksContentProvider;
import org.tcat.citd.sim.udig.bookmarks.internal.BookmarksLabelProvider;
import org.tcat.citd.sim.udig.bookmarks.internal.actions.BookmarkAction;

public class BookmarksView
extends ViewPart
implements ISetSelectionTarget {
    private TreeViewer bookmarksTree;
    private MenuManager menuMgr;
    private BookmarksLabelProvider labelProvider;
    private BookmarksContentProvider bookmarksProvider;

    public void dispose() {
        this.menuMgr.dispose();
        this.labelProvider.dispose();
        this.bookmarksProvider.dispose();
        this.bookmarksTree = null;
        super.dispose();
    }

    private void initPopup() {
        this.menuMgr = new MenuManager("#PopupMenu");
        this.menuMgr.setRemoveAllWhenShown(true);
        this.menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                BookmarksView.this.fillContextMenu(manager);
            }
        });
        Menu m = this.menuMgr.createContextMenu((Control)this.bookmarksTree.getTree());
        this.bookmarksTree.getTree().setMenu(m);
        this.getViewSite().registerContextMenu(this.menuMgr, (ISelectionProvider)this.bookmarksTree);
    }

    private void fillContextMenu(IMenuManager mm) {
        mm.add((IContributionItem)new GroupMarker("additions"));
    }

    public void createPartControl(Composite parent) {
        this.bookmarksTree = new TreeViewer(parent);
        this.bookmarksProvider = new BookmarksContentProvider();
        this.bookmarksTree.setContentProvider((IContentProvider)this.bookmarksProvider);
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)this.bookmarksProvider);
        this.labelProvider = new BookmarksLabelProvider();
        this.bookmarksTree.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.bookmarksTree.setSorter(new ViewerSorter());
        this.bookmarksTree.setInput((Object)this.bookmarksProvider);
        this.bookmarksTree.setAutoExpandLevel(2);
        this.bookmarksTree.addDoubleClickListener((IDoubleClickListener)new BookmarkAction());
        this.bookmarksTree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                final Object obj = ((IStructuredSelection)BookmarksView.this.bookmarksTree.getSelection()).getFirstElement();
                if (!(obj instanceof Bookmark)) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            BookmarksView.this.bookmarksTree.setExpandedState(obj, !BookmarksView.this.bookmarksTree.getExpandedState(obj));
                        }
                    });
                    return;
                }
            }
        });
        this.initPopup();
    }

    public void setFocus() {
        this.bookmarksTree.getControl().setFocus();
    }

    public void refresh() {
        ISelection selection = this.bookmarksTree.getSelection();
        this.bookmarksTree.refresh();
        if (selection.isEmpty()) {
            this.bookmarksTree.setSelection((ISelection)new StructuredSelection((Object)this.bookmarksProvider.getCurrentMap()));
        } else {
            this.bookmarksTree.setSelection(selection);
        }
    }

    public void selectReveal(ISelection selection) {
        this.bookmarksTree.setSelection(selection);
    }
}

