/*
 * Decompiled with CFR 0.152.
 */
package org.tcat.citd.sim.udig.bookmarks.internal.actions;

import com.vividsolutions.jts.geom.Envelope;
import java.util.Collection;
import java.util.List;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.NavCommand;
import net.refractions.udig.project.render.IViewportModel;
import net.refractions.udig.project.ui.ApplicationGIS;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.tcat.citd.sim.udig.bookmarks.Bookmark;
import org.tcat.citd.sim.udig.bookmarks.BookmarkCommandFactory;
import org.tcat.citd.sim.udig.bookmarks.BookmarksPlugin;
import org.tcat.citd.sim.udig.bookmarks.IBookmark;
import org.tcat.citd.sim.udig.bookmarks.IBookmarkService;
import org.tcat.citd.sim.udig.bookmarks.internal.MapReference;
import org.tcat.citd.sim.udig.bookmarks.internal.MapWrapper;
import org.tcat.citd.sim.udig.bookmarks.internal.Messages;
import org.tcat.citd.sim.udig.bookmarks.internal.ui.BookmarksView;

public class BookmarkAction
extends Action
implements IObjectActionDelegate,
IViewActionDelegate,
IDoubleClickListener {
    public static final String REMOVE_BOOKMARK_ACTION_ID = Messages.BookmarkAction_removebookmarkaction;
    public static final String REMOVE_MAP_ACTION_ID = Messages.BookmarkAction_removemapaction;
    public static final String REMOVE_PROJECT_ACTION_ID = Messages.BookmarkAction_removeprojectaction;
    public static final String REMOVE_ALL_ACTION_ID = Messages.BookmarkAction_removeallbookmarksaction;
    public static final String GOTO_BOOKMARK_ACTION_ID = Messages.BookmarkAction_gotobookmarkaction;
    public static final String ADD_BOOKMARK_ACTION_ID = Messages.BookmarkAction_addbookmarkaction;
    public static final String RENAME_BOOKMARK_ACTION_ID = Messages.BookmarkAction_renamebookmarkaction;
    public static final String SAVE_BOOKMARKS_ACTION_ID = Messages.BookmarkAction_savebookmarksaction;
    public static final String RESTORE_BOOKMARKS_ACTION_ID = Messages.BookmarkAction_restorebookmarksaction;
    private IViewPart view;
    private IStructuredSelection selection;
    private IBookmarkService bmManager;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        if (targetPart != null && targetPart instanceof IViewPart) {
            this.view = (IViewPart)targetPart;
        }
    }

    public void run(IAction action) {
        try {
            if (REMOVE_ALL_ACTION_ID.equals(action.getId())) {
                if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.BookmarkAction_dialogtitle_removebookmarks, (String)Messages.BookmarkAction_dialogprompt_removeallbookmarks)) {
                    if (this.bmManager == null) {
                        this.bmManager = BookmarksPlugin.getBookmarkService();
                    }
                    this.bmManager.empty();
                    this.refreshView();
                }
            } else if (REMOVE_MAP_ACTION_ID.equals(action.getId())) {
                int size = this.selection.size();
                if (size > 0) {
                    if (size > 1) {
                        if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.BookmarkAction_dialogtitle_removebookmarks, (String)Messages.BookmarkAction_dialogprompt_removemapbookmarks)) {
                            MapReference map = (MapReference)this.selection.getFirstElement();
                            if (this.bmManager == null) {
                                this.bmManager = BookmarksPlugin.getBookmarkService();
                            }
                            this.bmManager.removeMap(map);
                        }
                    } else if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.BookmarkAction_dialogtitle_removebookmarks, (String)Messages.BookmarkAction_dialogprompt_removeselectedmaps)) {
                        if (this.bmManager == null) {
                            this.bmManager = BookmarksPlugin.getBookmarkService();
                        }
                        List wrappedMaps = this.selection.toList();
                        Collection maps = MapWrapper.unwrap(wrappedMaps);
                        this.bmManager.removeMaps(maps);
                    }
                    this.refreshView();
                }
            } else if (REMOVE_BOOKMARK_ACTION_ID.equals(action.getId())) {
                int size = this.selection.size();
                if (size > 0) {
                    if (size > 1) {
                        if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.BookmarkAction_dialogtitle_removebookmarks, (String)Messages.BookmarkAction_dialogprompt_removeselectedbookmarks)) {
                            List bookmarks = this.selection.toList();
                            if (this.bmManager == null) {
                                this.bmManager = BookmarksPlugin.getBookmarkService();
                            }
                            this.bmManager.removeBookmarks(bookmarks);
                        }
                    } else if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.BookmarkAction_dialogtitle_removebookmark, (String)Messages.BookmarkAction_dialogprompt_removebookmark)) {
                        Bookmark bookmark = (Bookmark)this.selection.getFirstElement();
                        if (this.bmManager == null) {
                            this.bmManager = BookmarksPlugin.getBookmarkService();
                        }
                        this.bmManager.removeBookmark(bookmark);
                    }
                    this.refreshView();
                }
            } else if (GOTO_BOOKMARK_ACTION_ID.equals(action.getId())) {
                Bookmark bookmark = (Bookmark)this.selection.getFirstElement();
                this.gotoBookmark(bookmark);
            } else if (ADD_BOOKMARK_ACTION_ID.equals(action.getId())) {
                IMap map = ApplicationGIS.getActiveMap();
                if (map != ApplicationGIS.NO_MAP) {
                    IViewportModel v = map.getViewportModel();
                    ReferencedEnvelope env = v.getBounds();
                    ReferencedEnvelope bounds = env instanceof ReferencedEnvelope ? env : new ReferencedEnvelope((Envelope)env, v.getCRS());
                    MapReference ref = this.bmManager.getMapReference(map);
                    Bookmark bookmark = new Bookmark(bounds, ref, null);
                    InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.BookmarkAction_dialogtitle_bookmarklocation, Messages.BookmarkAction_dialogprompt_enterbookmarkname, bookmark.getName(), null);
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        String name = dialog.getValue();
                        bookmark.setName(name);
                        this.bmManager = BookmarksPlugin.getBookmarkService();
                        this.bmManager.addBookmark(bookmark);
                        this.refreshView();
                    }
                    ((BookmarksView)this.view).selectReveal((ISelection)new StructuredSelection((Object)bookmark));
                }
            } else if (RENAME_BOOKMARK_ACTION_ID.equals(action.getId())) {
                IBookmark bookmark = (IBookmark)this.selection.getFirstElement();
                InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.BookmarkAction_dialogtitle_renamebookmark, Messages.BookmarkAction_dialogprompt_enterbookmarkname, bookmark.getName(), null);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    String name = dialog.getValue();
                    bookmark.setName(name);
                    this.refreshView();
                }
            } else if (SAVE_BOOKMARKS_ACTION_ID.equals(action.getId())) {
                BookmarksPlugin.getDefault().storeToPreferences();
            } else if (RESTORE_BOOKMARKS_ACTION_ID.equals(action.getId())) {
                BookmarksPlugin.getDefault().restoreFromPreferences();
                this.refreshView();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void refreshView() {
        if (this.view != null && this.view instanceof BookmarksView) {
            BookmarksView bView = (BookmarksView)this.view;
            bView.refresh();
        }
    }

    private void gotoBookmark(Bookmark bookmark) {
        BookmarkCommandFactory factory = BookmarkCommandFactory.getInstance();
        NavCommand cmd = factory.createGotoBookmarkCommand(bookmark);
        ApplicationGIS.getActiveMap().sendCommandASync((MapCommand)cmd);
    }

    public void init(IViewPart viewPart) {
        if (viewPart != null) {
            this.view = viewPart;
        }
        if (this.bmManager == null) {
            this.bmManager = BookmarksPlugin.getBookmarkService();
        }
    }

    public void selectionChanged(IAction action, ISelection newSelection) {
        this.selection = (IStructuredSelection)newSelection;
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection eventSelection = (IStructuredSelection)event.getSelection();
        if (eventSelection.size() > 0 && eventSelection.getFirstElement() instanceof Bookmark) {
            Bookmark bookmark = (Bookmark)eventSelection.getFirstElement();
            this.gotoBookmark(bookmark);
        }
    }
}

