/*
 * Decompiled with CFR 0.152.
 */
package org.tcat.citd.sim.udig.bookmarks.internal;

import java.util.Collection;
import java.util.HashMap;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.MapPart;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.tcat.citd.sim.udig.bookmarks.Bookmark;
import org.tcat.citd.sim.udig.bookmarks.BookmarksPlugin;
import org.tcat.citd.sim.udig.bookmarks.IBookmarkService;
import org.tcat.citd.sim.udig.bookmarks.internal.MapReference;
import org.tcat.citd.sim.udig.bookmarks.internal.Messages;
import org.tcat.citd.sim.udig.bookmarks.internal.ui.BookmarksView;

public class BookmarksContentProvider
implements IStructuredContentProvider,
ITreeContentProvider,
IPartListener {
    private HashMap<Viewer, Object> viewers = new HashMap();
    private IWorkbenchPart currentPart = null;
    private IBookmarkService bManager = BookmarksPlugin.getBookmarkService();
    private MapReference currentMap = null;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput == null) {
            this.viewers.remove(viewer);
        } else {
            this.viewers.put(viewer, newInput);
        }
    }

    protected HashMap getViewers() {
        return this.viewers;
    }

    public void dispose() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().removePartListener((IPartListener)this);
        this.viewers.clear();
        this.bManager = null;
    }

    public Object[] getElements(Object parent) {
        Object[] elements = new Object[]{this.currentMap == null ? Messages.BookmarksContentProvider_emptybookmarkslist : this.currentMap};
        return elements;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = null;
        if (parentElement instanceof MapReference) {
            MapReference map = (MapReference)parentElement;
            children = this.bManager.getBookmarks(map).toArray();
        }
        return children;
    }

    public Object getParent(Object element) {
        MapReference parent = null;
        if (element instanceof Bookmark) {
            Bookmark bookmark = (Bookmark)element;
            parent = bookmark.getMap();
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        boolean hasChildren = false;
        if (element instanceof MapReference) {
            hasChildren = true;
        }
        return hasChildren;
    }

    public void refresh(final Viewer v, boolean asynch) {
        if (v.getControl().isDisposed()) {
            return;
        }
        Display display = v.getControl().getDisplay();
        if (display != null && !display.isDisposed()) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (v != null && !v.getControl().isDisposed()) {
                        v.refresh();
                        if (v instanceof TreeViewer) {
                            ((TreeViewer)v).expandToLevel((Object)BookmarksContentProvider.this.currentMap, 1);
                        }
                    }
                }
            };
            if (asynch) {
                display.asyncExec(r);
            } else {
                PlatformGIS.syncInDisplayThread((Runnable)r);
            }
        }
    }

    public void refresh(Collection<Viewer> c, boolean asynch) {
        for (Viewer v : c) {
            this.refresh(v, asynch);
        }
    }

    public MapReference getCurrentMap() {
        return this.currentMap;
    }

    public void setCurrentMap(MapReference currentMap) {
        this.currentMap = currentMap;
    }

    public void partActivated(IWorkbenchPart part) {
        if (part == this.currentPart) {
            return;
        }
        IMap map = null;
        if (part instanceof BookmarksView) {
            map = ApplicationGIS.getActiveMap();
        }
        if (map == null && part instanceof IAdaptable) {
            map = (IMap)part.getAdapter(Map.class);
        }
        if (map != null) {
            this.currentPart = part;
            MapReference ref = this.bManager.getMapReference(map);
            this.setCurrentMap(ref);
            this.refresh(this.viewers.keySet(), true);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this) {
            this.dispose();
            return;
        }
        if (part != this.currentPart) {
            return;
        }
        this.currentPart = null;
        if (part instanceof MapPart) {
            this.setCurrentMap(null);
        }
        this.refresh(this.viewers.keySet(), true);
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

