/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.util;

import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveChangeEvent;
import net.refractions.udig.catalog.IResolveDelta;
import net.refractions.udig.catalog.IResolveDeltaVisitor;
import net.refractions.udig.catalog.URLUtils;

public class SearchIDDeltaVisitor
implements IResolveDeltaVisitor {
    private IResolveDelta found;
    private URL id;

    public SearchIDDeltaVisitor(URL id) {
        this.id = id;
        this.found = null;
    }

    static List<URL> path(IResolve handle) {
        IResolve handle2 = handle;
        LinkedList<URL> path = new LinkedList<URL>();
        while (handle2 != null) {
            path.addFirst(handle2.getIdentifier());
            try {
                handle2 = handle2.parent(null);
            }
            catch (IOException iOException) {
                handle2 = null;
            }
        }
        return path;
    }

    public IResolveDelta getFound() {
        return this.found;
    }

    @Override
    public boolean visit(IResolveDelta delta) {
        if (delta.getKind() == IResolveDelta.Kind.NO_CHANGE) {
            return true;
        }
        URL here = delta.getResolve().getIdentifier();
        if (here == null) {
            return true;
        }
        if (URLUtils.urlEquals(here, this.id, false) || here.toExternalForm().startsWith(this.id.toExternalForm())) {
            this.found = delta;
            return false;
        }
        return true;
    }

    public static IResolveDelta search(URL id, IResolveChangeEvent event) {
        if (id == null || event == null) {
            return null;
        }
        IResolveDelta delta = event.getDelta();
        if (delta == null) {
            return null;
        }
        SearchIDDeltaVisitor visitor = new SearchIDDeltaVisitor(id);
        try {
            delta.accept(visitor);
            return visitor.getFound();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

