/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.util;

import java.lang.ref.WeakReference;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveChangeEvent;
import net.refractions.udig.catalog.IResolveChangeListener;
import net.refractions.udig.catalog.IResolveDelta;
import net.refractions.udig.catalog.util.SearchResolveDeltaVisitor;

public abstract class HandleListener
implements IResolveChangeListener {
    private WeakReference<IResolve> reference;

    public HandleListener(IResolve handle) {
        this.reference = new WeakReference<IResolve>(handle);
    }

    public IResolve getHandle() {
        if (this.reference == null) {
            return null;
        }
        if (this.reference.enqueue()) {
            this.dispose();
            return null;
        }
        IResolve handle = (IResolve)this.reference.get();
        if (handle == null) {
            this.dispose();
        }
        return null;
    }

    public void setHandle(IResolve newHandle) {
        this.reference.clear();
        this.reference = null;
        this.reference = new WeakReference<IResolve>(newHandle);
    }

    public abstract void start(IResolve var1);

    public abstract void stop(IResolve var1);

    public abstract void dispose();

    public abstract void refresh(IResolve var1);

    public abstract void replace(IResolve var1, IResolve var2);

    public abstract void reset(IResolve var1, IResolveChangeEvent var2);

    @Override
    public final void changed(IResolveChangeEvent event) {
        IResolve handle = this.getHandle();
        if (handle == null) {
            this.dispose();
            return;
        }
        if (event.getResolve() == handle) {
            switch (event.getType()) {
                case PRE_DELETE: {
                    this.stop(handle);
                    return;
                }
                case PRE_CLOSE: {
                    this.dispose();
                    return;
                }
            }
            this.refresh(handle);
            return;
        }
        IResolveDelta match = SearchResolveDeltaVisitor.search(handle, event);
        if (match == null) {
            return;
        }
        if (match.getResolve() == handle) {
            switch (match.getKind()) {
                case NO_CHANGE: {
                    return;
                }
                case ADDED: {
                    this.start(handle);
                    return;
                }
                case REMOVED: {
                    this.dispose();
                    return;
                }
                case REPLACED: {
                    if (match.getNewResolve() != null) {
                        this.replace(handle, match.getNewResolve());
                    } else {
                        this.reset(handle, event);
                    }
                    return;
                }
            }
            this.refresh(handle);
            return;
        }
        switch (match.getKind()) {
            case NO_CHANGE: 
            case ADDED: {
                return;
            }
            case REMOVED: {
                this.dispose();
                return;
            }
            case REPLACED: {
                this.reset(handle, event);
                return;
            }
        }
        this.refresh(handle);
    }
}

