/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.memory;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.ServiceExtension;
import net.refractions.udig.catalog.memory.MemoryDSFactory;
import net.refractions.udig.catalog.memory.internal.MemoryServiceImpl;
import org.geotools.data.DataUtilities;
import org.geotools.data.memory.MemoryDataStore;

public class MemoryServiceExtensionImpl
implements ServiceExtension {
    public static final String KEY = "scratch";
    public static final URL URL;
    public static final Map<URL, MemoryServiceImpl> impl;
    public static final String MEMBER_PARAM = "MEMBER_PARAM_KEY";
    private MemoryDSFactory factory;

    static {
        URL tmp;
        try {
            tmp = new URL("http://localhost/scratch");
        }
        catch (MalformedURLException e) {
            tmp = null;
            e.printStackTrace();
        }
        URL = tmp;
        impl = Collections.synchronizedMap(new HashMap());
    }

    public MemoryServiceExtensionImpl() {
    }

    public MemoryServiceExtensionImpl(MemoryDSFactory factory) {
        this.factory = factory;
    }

    @Override
    public IService createService(URL id2, Map<String, Serializable> params) {
        URL id = id2;
        if (params.containsKey(KEY)) {
            if (id == null) {
                id = (URL)params.get(KEY);
            }
            if (!impl.containsKey(id)) {
                impl.put(id, new MemoryServiceImpl(id, this.factory));
            }
            MemoryServiceImpl service = impl.get(id);
            MemoryDataStore store = null;
            try {
                store = service.resolve(MemoryDataStore.class, null);
            }
            catch (IOException e) {
                throw (RuntimeException)new RuntimeException(e.getLocalizedMessage()).initCause(e);
            }
            for (Map.Entry<String, Serializable> entry : params.entrySet()) {
                String[] members;
                if (!entry.getKey().equals(MEMBER_PARAM)) continue;
                String[] stringArray = members = ((String)((Object)entry.getValue())).split("_MEMBER_");
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    String member = stringArray[n2];
                    String[] spec = member.split("_SPLIT_");
                    try {
                        store.getSchema(spec[0]);
                    }
                    catch (Exception exception) {
                        try {
                            store.createSchema(DataUtilities.createType((String)spec[0], (String)spec[1]));
                        }
                        catch (Exception e2) {
                            CatalogPlugin.log("Error creating type in datastore", e2);
                        }
                    }
                    ++n2;
                }
            }
            return service;
        }
        return null;
    }

    @Override
    public Map<String, Serializable> createParams(URL url) {
        if (url != null && url.toExternalForm().startsWith(URL.toExternalForm())) {
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            map.put(KEY, url);
            return map;
        }
        return null;
    }
}

