/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.memory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.catalog.memory.internal.MemoryServiceListener;
import org.geotools.data.FeatureReader;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class ActiveMemoryDataStore
extends MemoryDataStore {
    List<MemoryServiceListener> list = new ArrayList<MemoryServiceListener>();

    public ActiveMemoryDataStore() {
    }

    public ActiveMemoryDataStore(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) {
        super(collection);
    }

    public ActiveMemoryDataStore(SimpleFeature[] array) {
        super(array);
    }

    public ActiveMemoryDataStore(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        super(reader);
    }

    public void addListener(MemoryServiceListener listener) {
        this.list.add(listener);
    }

    public boolean removeListener(MemoryServiceListener listener) {
        return this.list.remove(listener);
    }

    public void createSchema(SimpleFeatureType featureType) throws IOException {
        super.createSchema(featureType);
        for (MemoryServiceListener listener : this.list) {
            listener.schemaChanged();
        }
    }

    public void removeSchema(String typeName) {
        this.schema.remove(typeName);
        this.memory.remove(typeName);
        for (MemoryServiceListener listener : this.list) {
            listener.schemaChanged();
        }
    }
}

