/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveAdapterFactory;
import net.refractions.udig.catalog.IResolveManager;
import net.refractions.udig.catalog.ResolveAdapterFactory;
import net.refractions.udig.core.internal.ExtensionPointList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ResolveManager2
implements IResolveManager {
    private static final String RESOLVE_FACTORY_EXTENSION_POINT = "net.refractions.udig.catalog.resolvers";
    Map<String, Map<String, IResolveAdapterFactory>> adapterLookup;
    Map<Class<?>, List<Class<?>>> classSearchOrderLookup;
    Map<String, List<IResolveAdapterFactory>> factories = new HashMap<String, List<IResolveAdapterFactory>>();

    public ResolveManager2() {
        List extensionList = ExtensionPointList.getExtensionPointList((String)RESOLVE_FACTORY_EXTENSION_POINT);
        for (IConfigurationElement element : extensionList) {
            try {
                ResolveAdapterFactoryProxy proxy = new ResolveAdapterFactoryProxy(element);
                this.register(proxy);
            }
            catch (Throwable t) {
                CatalogPlugin.log(String.valueOf(element.getNamespaceIdentifier()) + " failed:" + t, t);
            }
        }
    }

    @Override
    public boolean canResolve(IResolve resolve, Class<?> targetClass) {
        String targetTypeName;
        Map<String, IResolveAdapterFactory> available = this.getFactories(resolve.getClass());
        IResolveAdapterFactory factory = available.get(targetTypeName = targetClass.getName());
        if (factory != null) {
            try {
                return factory.canAdapt(resolve, targetClass);
            }
            catch (Throwable t) {
                String msg = "IResolveAdapterFactory " + factory.getClass().getName() + " canAdapt check failed:" + t;
                CatalogPlugin.trace(msg, t);
                return false;
            }
        }
        List<IResolveAdapterFactory> genericFactories = this.factories.get(null);
        if (genericFactories != null) {
            for (IResolveAdapterFactory fallback : genericFactories) {
                try {
                    if (!fallback.canAdapt(resolve, targetClass)) continue;
                    return true;
                }
                catch (Throwable t) {
                    String factoryName = fallback.getClass().getName();
                    CatalogPlugin.trace("IResolveFactory " + factoryName + " unable to test for " + targetTypeName + ":" + t, t);
                }
            }
        }
        return false;
    }

    @Override
    public <T> T resolve(IResolve resolve, Class<T> targetClass, IProgressMonitor monitor) throws IOException {
        String targetTypeName = targetClass.getName();
        Map<String, IResolveAdapterFactory> available = this.getFactories(resolve.getClass());
        IResolveAdapterFactory factory = available.get(targetTypeName);
        if (factory != null) {
            T connected = factory.adapt(resolve, targetClass, monitor);
            return connected;
        }
        List<IResolveAdapterFactory> genericFactories = this.factories.get(null);
        for (IResolveAdapterFactory fallback : genericFactories) {
            try {
                T connected;
                if (!fallback.canAdapt(resolve, targetClass) || (connected = fallback.adapt(resolve, targetClass, monitor)) == null) continue;
                return connected;
            }
            catch (Throwable t) {
                String factoryName = fallback.getClass().getName();
                CatalogPlugin.trace("IResolveFactory " + factoryName + " unable to convert to " + targetTypeName + ":" + t, t);
            }
        }
        return null;
    }

    @Override
    public void register(ResolveAdapterFactory factory) {
        String className = factory.getResolveName();
        List<IResolveAdapterFactory> register = this.factories.get(className);
        if (register == null) {
            register = new ArrayList<IResolveAdapterFactory>(2);
            this.factories.put(className, register);
        }
        register.add(factory);
    }

    @Override
    public void registerResolves(IResolveAdapterFactory factory) {
        if (factory instanceof ResolveAdapterFactory) {
            this.register((ResolveAdapterFactory)factory);
        } else {
            this.registerGeneric(factory);
        }
    }

    private void registerGeneric(IResolveAdapterFactory factory) {
        List<IResolveAdapterFactory> register = this.factories.get(null);
        if (register == null) {
            register = new ArrayList<IResolveAdapterFactory>(2);
            this.factories.put(null, register);
        }
        GenericResolveAdapterFactory item = new GenericResolveAdapterFactory(factory);
        register.add(item);
    }

    @Override
    public void unregisterResolves(IResolveAdapterFactory factory) {
        if (factory instanceof ResolveAdapterFactory) {
            this.unregister((ResolveAdapterFactory)factory);
        } else {
            this.unregisterGeneric(factory);
        }
    }

    @Override
    public void unregister(ResolveAdapterFactory factory) {
        String className = factory.getResolveName();
        List<IResolveAdapterFactory> register = this.factories.get(className);
        if (register != null) {
            register.remove(factory);
        }
    }

    @Override
    public void unregisterResolves(IResolveAdapterFactory factory, Class<?> resolveType) {
        GenericResolveAdapterFactory item = this.lookupGenericFactory(factory);
        item.getExcludes().add(resolveType);
    }

    private void unregisterGeneric(IResolveAdapterFactory factory) {
        List<IResolveAdapterFactory> register = this.factories.get(null);
        if (register != null) {
            GenericResolveAdapterFactory item = this.lookupGenericFactory(factory);
            register.remove(item);
        }
    }

    private GenericResolveAdapterFactory lookupGenericFactory(IResolveAdapterFactory factory) {
        List<IResolveAdapterFactory> genericFactories = this.factories.get(null);
        if (genericFactories == null) {
            return null;
        }
        for (IResolveAdapterFactory generic : genericFactories) {
            GenericResolveAdapterFactory manual;
            if (!(generic instanceof GenericResolveAdapterFactory) || (manual = (GenericResolveAdapterFactory)generic) != factory && manual.getFactory() != factory) continue;
            return manual;
        }
        return null;
    }

    private Map<String, IResolveAdapterFactory> getFactories(Class<?> resolveClass) {
        String resolveName;
        Map<String, IResolveAdapterFactory> table;
        if (this.adapterLookup == null) {
            this.adapterLookup = Collections.synchronizedMap(new HashMap());
        }
        if ((table = this.adapterLookup.get(resolveName = resolveClass.getName())) != null) {
            return table;
        }
        table = new HashMap<String, IResolveAdapterFactory>();
        for (Class<?> type : this.searchOrder(resolveClass)) {
            String typeName = type.getName();
            this.addFactoriesFor(typeName, table);
        }
        this.adapterLookup.put(resolveName, table);
        return table;
    }

    public List<Class<?>> searchOrder(Class<?> resolveClass) {
        List<Class<?>> classes;
        if (this.classSearchOrderLookup == null) {
            this.classSearchOrderLookup = new HashMap();
        }
        if ((classes = this.classSearchOrderLookup.get(resolveClass)) == null) {
            classes = this.doComputeClassOrder(resolveClass);
            this.classSearchOrderLookup.put(resolveClass, classes);
        }
        return classes;
    }

    private List<Class<?>> doComputeClassOrder(Class<?> resolveClass) {
        ArrayList classHierarchy = new ArrayList();
        Class<?> traverse = resolveClass;
        while (traverse != null) {
            classHierarchy.add(traverse);
            traverse = traverse.getSuperclass();
        }
        ArrayList searchOrder = new ArrayList(classHierarchy);
        HashSet seen = new HashSet(4);
        for (Class clazz : classHierarchy) {
            this.computeInterfaceOrder(clazz.getInterfaces(), searchOrder, seen);
        }
        return Collections.unmodifiableList(searchOrder);
    }

    private void computeInterfaceOrder(Class<?>[] interfaces, List<Class<?>> classes, Set<Class<?>> seen) {
        ArrayList<Class> newInterfaces = new ArrayList<Class>(interfaces.length);
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class interfaceClass = classArray[n2];
            if (!seen.contains(interfaceClass)) {
                seen.add(interfaceClass);
                newInterfaces.add(interfaceClass);
            }
            ++n2;
        }
        for (Class interfaceClass : newInterfaces) {
            this.computeInterfaceOrder(interfaceClass.getInterfaces(), classes, seen);
        }
    }

    private void addFactoriesFor(String typeName, Map<String, IResolveAdapterFactory> table) {
        List<IResolveAdapterFactory> factoryList = this.factories.get(typeName);
        if (factoryList == null) {
            return;
        }
        for (IResolveAdapterFactory factory : factoryList) {
            if (factory instanceof ResolveAdapterFactoryProxy) {
                ResolveAdapterFactoryProxy proxy = (ResolveAdapterFactoryProxy)factory;
                for (String string : proxy.getAdapterNames()) {
                    if (table.get(string) != null) continue;
                    table.put(string, factory);
                }
                continue;
            }
            if (!(factory instanceof ResolveAdapterFactory)) continue;
            ResolveAdapterFactory factory2 = (ResolveAdapterFactory)factory;
            for (Class clazz : factory2.getAdapterList()) {
                String adapterName = clazz.getName();
                if (table.get(adapterName) != null) continue;
                table.put(adapterName, factory);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static Class<?> loadClass(IResolveAdapterFactory factory, String className) {
        block4: {
            if (className == null) {
                return null;
            }
            try {
                contextClassloader = factory.getClass().getClassLoader();
                return contextClassloader.loadClass(className);
            }
            catch (ClassNotFoundException v0) {
                if (!(factory instanceof ResolveAdapterFactory)) break block4;
                ** for (adpaterClass : ((ResolveAdapterFactory)factory).getAdapterList())
            }
lbl-1000:
            // 1 sources

            {
                adapterName = adpaterClass.getCanonicalName();
                if (!className.equals(adapterName)) continue;
                return adpaterClass;
            }
        }
        return null;
    }

    static class GenericResolveAdapterFactory
    implements IResolveAdapterFactory {
        IResolveAdapterFactory factory;
        Set<Class<?>> excludes = new HashSet();

        GenericResolveAdapterFactory(IResolveAdapterFactory factory) {
            if (factory == null) {
                throw new NullPointerException("Factory required");
            }
            this.factory = factory;
        }

        @Override
        public boolean canAdapt(IResolve resolve, Class<? extends Object> adapterType) {
            if (this.excludes.contains(adapterType)) {
                return false;
            }
            return this.factory.canAdapt(resolve, adapterType);
        }

        @Override
        public <T> T adapt(IResolve resolve, Class<T> adapterType, IProgressMonitor monitor) throws IOException {
            return this.factory.adapt(resolve, adapterType, monitor);
        }

        public Set<Class<?>> getExcludes() {
            return this.excludes;
        }

        public IResolveAdapterFactory getFactory() {
            return this.factory;
        }

        public String toString() {
            return "ManualResolveAdapterFactory " + this.factory.getClass().getName() + " excludes:" + this.excludes;
        }
    }

    static class ResolveAdapterFactoryProxy
    extends ResolveAdapterFactory {
        IConfigurationElement config;
        IResolveAdapterFactory factory;
        Map<String, Class<?>> adapterTypes = new HashMap();
        private String resolveName;
        private Class<?> resolveType;

        public ResolveAdapterFactoryProxy(ResolveAdapterFactory factory) {
            this.config = null;
            this.factory = factory;
            for (Class<?> adapterClass : factory.getAdapterList()) {
                String adapterTypeName = adapterClass.getName();
                this.adapterTypes.put(adapterTypeName, adapterClass);
            }
            this.resolveName = factory.getResolveName();
            this.resolveType = factory.getResolveType();
        }

        public ResolveAdapterFactoryProxy(IConfigurationElement config) {
            this.config = config;
            this.resolveName = config.getAttribute("resolveableType");
            IConfigurationElement[] iConfigurationElementArray = config.getChildren("resolve");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                String adapterTypeName = element.getAttribute("type");
                this.adapterTypes.put(adapterTypeName, null);
                ++n2;
            }
        }

        @Override
        public String getResolveName() {
            return this.resolveName;
        }

        @Override
        public synchronized Class<?> getResolveType() {
            if (this.resolveType == null) {
                this.resolveType = ResolveManager2.loadClass(this.factory, this.resolveName);
            }
            return this.resolveType;
        }

        private synchronized void loadFactory() {
            if (this.factory == null) {
                try {
                    this.factory = (IResolveAdapterFactory)this.config.createExecutableExtension("class");
                }
                catch (CoreException problem) {
                    String factoryName = this.config.getAttribute("class");
                    this.factory = new ExceptionResolveAdapaterFactory(factoryName, problem);
                }
            }
        }

        @Override
        public boolean canAdapt(IResolve resolve, Class<? extends Object> adapterType) {
            String adapterName = adapterType.getName();
            if (!this.adapterTypes.containsKey(adapterName)) {
                return false;
            }
            if (this.factory == null) {
                this.loadFactory();
            }
            return this.factory.canAdapt(resolve, adapterType);
        }

        @Override
        public <T> T adapt(IResolve resolve, Class<T> adapterType, IProgressMonitor monitor) throws IOException {
            if (this.factory == null) {
                this.loadFactory();
            }
            return this.factory.adapt(resolve, adapterType, monitor);
        }

        @Override
        public List<String> getAdapterNames() {
            return new ArrayList<String>(this.adapterTypes.keySet());
        }

        @Override
        public List<Class<?>> getAdapterList() {
            ArrayList types = new ArrayList();
            for (Map.Entry<String, Class<?>> entry : this.adapterTypes.entrySet()) {
                String adapterName;
                Class adapterType = entry.getValue();
                if (adapterType == null && (adapterType = ResolveManager2.loadClass(this.factory, adapterName = entry.getKey())) == null) {
                    this.adapterTypes.remove(adapterName);
                    continue;
                }
                types.add(adapterType);
            }
            return types;
        }

        static class ExceptionResolveAdapaterFactory
        extends ResolveAdapterFactory {
            CoreException problem;
            private String factoryName;

            public ExceptionResolveAdapaterFactory(String factoryName, CoreException coreException) {
                this.factoryName = factoryName;
                this.problem = coreException;
            }

            @Override
            public <T> T adapt(IResolve resolve, Class<T> adapter, IProgressMonitor monitor) throws IOException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(this.problem.toString(), 1);
                monitor.done();
                throw new IOException("IResolveAdapterFactory " + this.factoryName + " unavailable:" + (Object)((Object)this.problem), this.problem);
            }

            @Override
            public boolean canAdapt(IResolve resolve, Class<? extends Object> adapter) {
                return false;
            }

            @Override
            public List<Class<?>> getAdapterList() {
                return Collections.emptyList();
            }

            @Override
            public List<String> getAdapterNames() {
                return Collections.emptyList();
            }

            @Override
            public Class<?> getResolveType() {
                return Void.class;
            }

            @Override
            public String getResolveName() {
                return "java.lang.Void";
            }
        }
    }
}

