/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveAdapterFactory;
import net.refractions.udig.catalog.IResolveManager;
import net.refractions.udig.catalog.ResolveAdapterFactory;
import net.refractions.udig.core.internal.ExtensionPointList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class ResolveManager
implements IResolveManager {
    private static final String LIST_ID = "net.refractions.udig.catalog.resolvers";
    Map<IConfigurationElement, IResolveAdapterFactory> factories = new HashMap<IConfigurationElement, IResolveAdapterFactory>();
    Map<IResolveAdapterFactory, Set<Class<?>>> exceptions = new HashMap();
    Set<IResolveAdapterFactory> registeredFactories = new HashSet<IResolveAdapterFactory>();

    public ResolveManager() {
        List extensionList = ExtensionPointList.getExtensionPointList((String)LIST_ID);
        for (IConfigurationElement element : extensionList) {
            this.factories.put(element, null);
        }
    }

    @Override
    public boolean canResolve(IResolve resolve, Class<?> adapter) {
        for (Map.Entry<IConfigurationElement, IResolveAdapterFactory> entry : this.factories.entrySet()) {
            IConfigurationElement element = entry.getKey();
            try {
                IResolveAdapterFactory factory;
                if (!this.isResolvableType(element, resolve) || !this.isTargetTypeSupported(element, adapter) || !(factory = this.getResolveAdapterFactory(entry)).canAdapt(resolve, adapter)) continue;
                return true;
            }
            catch (RuntimeException ignore) {
                CatalogPlugin.log(ignore.getLocalizedMessage(), ignore);
            }
        }
        for (IResolveAdapterFactory factory : this.registeredFactories) {
            try {
                Set<Class<?>> ignoreSet = this.exceptions.get(factory);
                if (ignoreSet != null && ignoreSet.contains(adapter) || !factory.canAdapt(resolve, adapter)) continue;
                return true;
            }
            catch (RuntimeException ignore) {
                CatalogPlugin.log(ignore.getLocalizedMessage(), ignore);
            }
        }
        return false;
    }

    private boolean isResolvableType(IConfigurationElement element, IResolve resolve) {
        String requiredType = element.getAttribute("resolveableType");
        if (requiredType == null) {
            String badPuppy = element.getContributor().getName();
            if (badPuppy == null) {
                badPuppy = "A plugin";
            }
            System.out.println(String.valueOf(badPuppy) + " failed to configure ResolveAdaptorFactory: requiredType missing ");
            return false;
        }
        try {
            Class<?> clazz = resolve.getClass().getClassLoader().loadClass(requiredType);
            return clazz.isAssignableFrom(resolve.getClass());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private boolean isTargetTypeSupported(IConfigurationElement element, Class<?> target) {
        IConfigurationElement[] resolveList;
        IConfigurationElement[] iConfigurationElementArray = resolveList = element.getChildren("resolve");
        int n = resolveList.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                String resolveType;
                block11: {
                    IConfigurationElement child = iConfigurationElementArray[n2];
                    resolveType = child.getAttribute("type");
                    if (!resolveType.startsWith("net.refractions") && !resolveType.startsWith("eu.udig")) {
                        try {
                            Class<?> resolvedClass;
                            ClassLoader classLoader = target.getClassLoader();
                            if (classLoader == null) {
                                classLoader = ClassLoader.getSystemClassLoader();
                            }
                            if (target.isAssignableFrom(resolvedClass = classLoader.loadClass(resolveType))) {
                                return true;
                            }
                            break block10;
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    }
                    IResolveAdapterFactory factory = this.getResolveAdapterFactory(element);
                    if (factory instanceof BrokenIResolveAdapaterFactory) break block10;
                    ClassLoader classLoader = factory.getClass().getClassLoader();
                    if (classLoader == null) break block11;
                    Class<?> resolvedClass = classLoader.loadClass(resolveType);
                    if (target.isAssignableFrom(resolvedClass)) {
                        return true;
                    }
                }
                try {
                    throw new ClassNotFoundException(resolveType);
                }
                catch (ClassNotFoundException notFound) {
                    ILog log = CatalogPlugin.getDefault().getLog();
                    Status status = new Status(2, element.getContributor().getName(), "Cannot determine resolve class for " + element.getDeclaringExtension().getUniqueIdentifier(), (Throwable)notFound);
                    log.log((IStatus)status);
                }
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void registerResolves(IResolveAdapterFactory factory) {
        this.registeredFactories.add(factory);
    }

    @Override
    public void register(ResolveAdapterFactory factory) {
        this.registeredFactories.add(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IResolveAdapterFactory getResolveAdapterFactory(Map.Entry<IConfigurationElement, IResolveAdapterFactory> entry) {
        Map<IConfigurationElement, IResolveAdapterFactory> map = this.factories;
        synchronized (map) {
            IResolveAdapterFactory factory;
            if (entry.getValue() != null) {
                return entry.getValue();
            }
            IConfigurationElement element = entry.getKey();
            try {
                factory = (IResolveAdapterFactory)element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                CatalogPlugin.log(e.toString(), e);
                factory = new BrokenIResolveAdapaterFactory(e);
            }
            entry.setValue(factory);
            return factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IResolveAdapterFactory getResolveAdapterFactory(IConfigurationElement element) {
        Map<IConfigurationElement, IResolveAdapterFactory> map = this.factories;
        synchronized (map) {
            IResolveAdapterFactory factory = this.factories.get(element);
            if (factory != null) {
                return factory;
            }
            try {
                factory = (IResolveAdapterFactory)element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                String message = "Marking IResolveAdaptorFactory as unavaiable:" + (Object)((Object)e);
                Status status = new Status(2, element.getContributor().getName(), message, (Throwable)e);
                CatalogPlugin.getDefault().getLog().log((IStatus)status);
                factory = new BrokenIResolveAdapaterFactory(e);
            }
            this.factories.put(element, factory);
            return factory;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T resolve(IResolve resolve, Class<T> adapter, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        int count = this.registeredFactories.size() + this.factories.size();
        monitor.beginTask("Searching for " + adapter.getCanonicalName(), count * 10);
        try {
            for (Map.Entry<IConfigurationElement, IResolveAdapterFactory> entry : this.factories.entrySet()) {
                IConfigurationElement element = entry.getKey();
                try {
                    if (this.isResolvableType(element, resolve) && this.isTargetTypeSupported(element, adapter)) {
                        IResolveAdapterFactory factory = this.getResolveAdapterFactory(entry);
                        if (factory.canAdapt(resolve, adapter)) {
                            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)factory.getClass().getCanonicalName(), (int)10);
                            T value = factory.adapt(resolve, adapter, (IProgressMonitor)subMonitor);
                            if (value == null) continue;
                            T t = adapter.cast(value);
                            return t;
                        }
                        monitor.worked(10);
                        continue;
                    }
                    monitor.worked(10);
                }
                catch (RuntimeException ignore) {
                    CatalogPlugin.log(ignore.getLocalizedMessage(), ignore);
                }
            }
            for (IResolveAdapterFactory factory : this.registeredFactories) {
                try {
                    Set<Class<?>> ignoreSet = this.exceptions.get(factory);
                    if (ignoreSet != null && ignoreSet.contains(adapter)) {
                        monitor.worked(10);
                        continue;
                    }
                    if (factory.canAdapt(resolve, adapter)) {
                        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)factory.getClass().getCanonicalName(), (int)10);
                        T value = factory.adapt(resolve, adapter, (IProgressMonitor)subMonitor);
                        if (value == null) continue;
                        T t = adapter.cast(value);
                        return t;
                    }
                    monitor.worked(10);
                }
                catch (RuntimeException ignore) {
                    CatalogPlugin.log(ignore.getLocalizedMessage(), ignore);
                }
            }
            return null;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void unregisterResolves(IResolveAdapterFactory factory) {
        this.registeredFactories.remove(factory);
        this.exceptions.remove(this.registeredFactories);
    }

    @Override
    public void unregister(ResolveAdapterFactory factory) {
        this.registeredFactories.remove(factory);
        this.exceptions.remove(this.registeredFactories);
    }

    @Override
    public void unregisterResolves(IResolveAdapterFactory factory, Class<?> resolveType) {
        if (!this.registeredFactories.contains(factory)) {
            throw new IllegalArgumentException(factory + " is not a registered factory");
        }
        Set<Class<?>> set = this.exceptions.get(factory);
        if (set == null) {
            set = new HashSet();
            this.exceptions.put(factory, set);
        }
        set.add(resolveType);
    }

    static class BrokenIResolveAdapaterFactory
    implements IResolveAdapterFactory {
        CoreException problem;

        public BrokenIResolveAdapaterFactory(CoreException coreException) {
            this.problem = coreException;
        }

        @Override
        public <T> T adapt(IResolve resolve, Class<T> adapter, IProgressMonitor monitor) throws IOException {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(this.problem.toString(), 1);
            monitor.done();
            throw (IOException)new IOException("This factory is broken:" + this.problem).initCause((Throwable)this.problem);
        }

        @Override
        public boolean canAdapt(IResolve resolve, Class<? extends Object> adapter) {
            return false;
        }
    }
}

