/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveDelta;
import net.refractions.udig.catalog.IResolveDeltaVisitor;
import net.refractions.udig.catalog.internal.Messages;

public class ResolveDelta
implements IResolveDelta {
    private List<IResolveDelta> children;
    private IResolveDelta.Kind kind = IResolveDelta.Kind.NO_CHANGE;
    private IResolve handle = null;
    private IResolve newHandle = null;
    private final Object newValue;
    private final Object oldValue;

    public ResolveDelta() {
        this.kind = IResolveDelta.Kind.CHANGED;
        this.children = NO_CHILDREN;
        this.handle = CatalogPlugin.getDefault().getLocalCatalog();
        this.oldValue = null;
        this.newValue = null;
        this.newHandle = null;
    }

    public ResolveDelta(IResolve handle, List<IResolveDelta> changes) {
        this.kind = IResolveDelta.Kind.CHANGED;
        this.children = Collections.unmodifiableList(changes);
        this.handle = handle;
        if (this.kind == IResolveDelta.Kind.REPLACED) {
            throw new IllegalArgumentException(Messages.ResolveDelta_error_newHandleRequired);
        }
        this.newHandle = null;
        this.oldValue = null;
        this.newValue = null;
    }

    public ResolveDelta(IResolve handle, IResolveDelta.Kind kind) {
        this.kind = kind;
        this.children = NO_CHILDREN;
        this.handle = handle;
        if (kind == IResolveDelta.Kind.REPLACED) {
            throw new IllegalArgumentException(Messages.ResolveDelta_error_newHandleRequired);
        }
        this.newHandle = null;
        this.oldValue = null;
        this.newValue = null;
    }

    public ResolveDelta(IResolve handle, IResolveDelta.Kind kind, List<IResolveDelta> changes) {
        this.kind = kind;
        List<IResolveDelta> changes2 = changes;
        if (changes2 == null) {
            changes2 = new ArrayList<IResolveDelta>();
        }
        this.children = Collections.unmodifiableList(changes2);
        this.handle = handle;
        if (kind == IResolveDelta.Kind.REPLACED) {
            throw new IllegalArgumentException(Messages.ResolveDelta_error_newHandleRequired);
        }
        this.newHandle = null;
        this.oldValue = null;
        this.newValue = null;
    }

    public ResolveDelta(IResolve handle, IResolve newHandle, List<IResolveDelta> changes) {
        this.kind = IResolveDelta.Kind.REPLACED;
        List<IResolveDelta> changes2 = changes;
        if (changes2 == null) {
            changes2 = new ArrayList<IResolveDelta>();
        }
        this.children = Collections.unmodifiableList(changes2);
        this.handle = handle;
        this.newHandle = newHandle;
        this.oldValue = null;
        this.newValue = null;
    }

    public ResolveDelta(IResolve handle, Object oldValue, Object newValue) {
        this.kind = IResolveDelta.Kind.CHANGED;
        this.children = NO_CHILDREN;
        this.handle = handle;
        this.newHandle = null;
        this.newValue = newValue;
        this.oldValue = oldValue;
    }

    @Override
    public void accept(IResolveDeltaVisitor visitor) throws IOException {
        if (visitor.visit(this)) {
            for (IResolveDelta delta : this.children) {
                if (delta == null || !visitor.visit(delta)) continue;
                delta.accept(visitor);
            }
        }
    }

    @Override
    public List<IResolveDelta> getChildren() {
        return this.children;
    }

    @Override
    public List<IResolveDelta> getChildren(EnumSet<IResolveDelta.Kind> kindMask) {
        ArrayList<IResolveDelta> list = new ArrayList<IResolveDelta>();
        for (IResolveDelta delta : this.children) {
            if (delta == null || !kindMask.contains((Object)delta.getKind())) continue;
            list.add(delta);
        }
        return list;
    }

    @Override
    public IResolveDelta.Kind getKind() {
        return this.kind;
    }

    @Override
    public IResolve getResolve() {
        return this.handle;
    }

    @Override
    public IResolve getNewResolve() {
        return this.newHandle;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ResolveDelta: [");
        buffer.append((Object)this.kind);
        if (this.handle != null) {
            buffer.append(",");
            buffer.append(this.handle);
        }
        if (this.newHandle != null) {
            buffer.append(",");
            buffer.append(this.newHandle);
        }
        if (this.children != null) {
            buffer.append("children [");
            int i = 0;
            while (i < this.children.size()) {
                buffer.append((Object)this.children.get(i).getKind());
                ++i;
            }
            buffer.append("] ");
        }
        buffer.append("] ");
        return buffer.toString();
    }

    @Override
    public Object getNewValue() {
        return this.newValue;
    }

    @Override
    public Object getOldValue() {
        return this.oldValue;
    }
}

