/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.document;

import java.io.File;
import java.net.URL;
import java.util.List;
import net.refractions.udig.catalog.document.IAbstractDocumentSource;
import net.refractions.udig.catalog.document.IDocument;
import org.eclipse.core.runtime.IProgressMonitor;
import org.opengis.feature.simple.SimpleFeature;

public interface IHotlinkSource
extends IAbstractDocumentSource {
    public boolean canSetHotlink();

    public boolean canClearHotlink();

    public List<HotlinkDescriptor> getHotlinkDescriptors(SimpleFeature var1, IProgressMonitor var2);

    public List<IDocument> getDocuments(SimpleFeature var1, IProgressMonitor var2);

    public IDocument getDocument(SimpleFeature var1, String var2, IProgressMonitor var3);

    public boolean setFile(SimpleFeature var1, String var2, File var3, IProgressMonitor var4);

    public boolean setLink(SimpleFeature var1, String var2, URL var3, IProgressMonitor var4);

    public boolean setAction(SimpleFeature var1, String var2, String var3, IProgressMonitor var4);

    public boolean clear(SimpleFeature var1, String var2, IProgressMonitor var3);

    public static class HotlinkDescriptor {
        private final String label;
        private final String description;
        private final String attributeName;
        private final IDocument.ContentType type;
        private final String config;
        public static final String DELIMITER = "|~|";
        public static final String DELIMITER_REGEX = "\\|~\\|";

        public HotlinkDescriptor() {
            this.label = null;
            this.description = null;
            this.attributeName = null;
            this.type = IDocument.ContentType.FILE;
            this.config = null;
        }

        public HotlinkDescriptor(HotlinkDescriptor descriptor) {
            this.label = descriptor.getLabel();
            this.description = descriptor.getDescription();
            this.attributeName = descriptor.getAttributeName();
            this.type = descriptor.getType();
            this.config = descriptor.getConfig();
        }

        public HotlinkDescriptor(String attributeName, IDocument.ContentType type) {
            this.label = null;
            this.description = null;
            this.attributeName = attributeName;
            this.type = type;
            this.config = null;
        }

        public HotlinkDescriptor(String label, String description, String attributeName, IDocument.ContentType type, String config) {
            this.label = label;
            this.description = description;
            this.attributeName = attributeName;
            this.type = type;
            this.config = config;
        }

        public HotlinkDescriptor(String definition) {
            String[] defValues = definition.split(DELIMITER_REGEX);
            this.attributeName = this.getCleanValue(defValues[0]);
            this.type = IDocument.ContentType.valueOf(defValues[1]);
            this.config = defValues.length > 2 ? this.getCleanValue(defValues[2]) : null;
            this.label = defValues.length > 3 ? this.getCleanValue(defValues[3]) : null;
            this.description = defValues.length > 4 ? this.getCleanValue(defValues[4]) : null;
        }

        private String getCleanValue(String text) {
            String cleanText;
            if (text != null && (cleanText = text.trim()).length() > 0) {
                return cleanText;
            }
            return null;
        }

        public boolean isEmpty() {
            return this.attributeName == null || this.attributeName.isEmpty();
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public IDocument.ContentType getType() {
            return this.type;
        }

        public String getConfig() {
            return this.config;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.attributeName != null) {
                sb.append(this.attributeName);
            }
            sb.append(DELIMITER);
            if (this.type != null) {
                sb.append((Object)this.type);
            }
            sb.append(DELIMITER);
            if (this.config != null) {
                sb.append(this.config);
            }
            sb.append(DELIMITER);
            if (this.label != null) {
                sb.append(this.label);
            }
            sb.append(DELIMITER);
            if (this.description != null) {
                sb.append(this.description);
            }
            return sb.toString();
        }
    }
}

