/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import net.refractions.udig.ui.graphics.AWTSWTImageUtils;
import org.eclipse.jface.resource.ImageDescriptor;

public class IServiceInfo {
    protected String title;
    protected String description;
    protected String _abstract;
    protected URI schema;
    protected URI source;
    protected URI publisher;
    protected String[] keywords;
    protected ImageDescriptor icon;
    private Icon awtIcon;

    protected IServiceInfo() {
    }

    public IServiceInfo(String title, String description, String _abstract, URI source, URI publisher, URI schema, String[] keywords, ImageDescriptor icon) {
        this.title = title;
        this.description = description;
        this._abstract = _abstract;
        this.schema = schema;
        this.source = source;
        this.publisher = publisher;
        int i = 0;
        if (keywords != null) {
            i = keywords.length;
        }
        String[] k = new String[i];
        if (keywords != null) {
            System.arraycopy(keywords, 0, k, 0, k.length);
        }
        this.keywords = k;
        this.icon = icon;
    }

    public String getTitle() {
        return this.title;
    }

    public String getShortTitle() {
        return this.getTitle();
    }

    public Set<String> getKeywords() {
        if (this.keywords == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(this.keywords));
    }

    public String getDescription() {
        return this.description;
    }

    public String getAbstract() {
        return this._abstract;
    }

    public URI getPublisher() {
        return this.publisher;
    }

    public URI getSchema() {
        return this.schema;
    }

    public URI getSource() {
        return this.source;
    }

    public Icon getIcon() {
        if (this.awtIcon != null) {
            return this.awtIcon;
        }
        if (this.icon == null) {
            return null;
        }
        Icon awtIcon = AWTSWTImageUtils.imageDescriptor2awtIcon((ImageDescriptor)this.icon);
        return awtIcon;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.icon != null) {
            return this.icon;
        }
        Icon icon2 = this.getIcon();
        if (icon2 == null) {
            return null;
        }
        return AWTSWTImageUtils.awtIcon2ImageDescriptor((Icon)icon2);
    }

    public double getMetric() {
        return 0.0;
    }
}

