/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.ICatalogInfo;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveChangeListener;
import net.refractions.udig.catalog.ISearch;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.Messages;
import net.refractions.udig.ui.ErrorManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public abstract class IRepository
extends ISearch {
    public abstract IService add(IService var1) throws UnsupportedOperationException;

    public abstract void remove(IService var1) throws UnsupportedOperationException;

    public abstract IService acquire(Map<String, Serializable> var1, IProgressMonitor var2) throws IOException;

    public abstract IService acquire(URL var1, IProgressMonitor var2) throws IOException;

    public abstract void replace(ID var1, IService var2) throws UnsupportedOperationException;

    @Override
    public abstract <T> T resolve(Class<T> var1, IProgressMonitor var2) throws IOException;

    @Override
    public ICatalogInfo getInfo(IProgressMonitor monitor) throws IOException {
        return this.resolve(ICatalogInfo.class, monitor);
    }

    public abstract void addListener(IResolveChangeListener var1);

    public abstract void removeListener(IResolveChangeListener var1);

    @Override
    public void dispose(IProgressMonitor monitor) {
        List<IResolve> members;
        monitor.beginTask(Messages.ICatalog_dispose, 100);
        try {
            members = this.members((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (Throwable e) {
            ErrorManager.get().displayException(e, "Error disposing members of catalog: " + this.getIdentifier(), "net.refractions.udig.catalog");
            return;
        }
        int steps = (int)(99.0 / (double)members.size());
        for (IResolve resolve : members) {
            try {
                SubProgressMonitor subProgressMonitor = new SubProgressMonitor(monitor, steps);
                resolve.dispose((IProgressMonitor)subProgressMonitor);
                subProgressMonitor.done();
            }
            catch (Throwable e) {
                ErrorManager.get().displayException(e, "Error disposing members of catalog: " + this.getIdentifier(), "net.refractions.udig.catalog");
            }
        }
    }
}

