/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog;

import com.vividsolutions.jts.geom.Envelope;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import net.refractions.udig.ui.graphics.AWTSWTImageUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class IGeoResourceInfo {
    protected String title;
    protected String description;
    protected String name;
    protected String[] keywords;
    protected URI schema;
    protected ImageDescriptor icon;
    protected ReferencedEnvelope bounds;
    private Icon awtIcon;

    protected IGeoResourceInfo() {
    }

    public IGeoResourceInfo(String title, String name, String description, URI schema, Envelope bounds, CoordinateReferenceSystem crs, String[] keywords, ImageDescriptor icon) {
        this.title = title;
        this.description = description;
        this.name = name;
        int i = 0;
        if (keywords != null) {
            i = keywords.length;
        }
        String[] k = new String[i];
        if (keywords != null) {
            System.arraycopy(keywords, 0, k, 0, k.length);
        }
        this.keywords = k;
        this.schema = schema;
        this.icon = icon;
        this.bounds = new ReferencedEnvelope(bounds, crs);
    }

    public String getTitle() {
        return this.title;
    }

    public Set<String> getKeywords() {
        if (this.keywords == null) {
            return Collections.emptySet();
        }
        List<String> asList = Arrays.asList(this.keywords);
        HashSet<String> set = new HashSet<String>(asList);
        return set;
    }

    public String getDescription() {
        return this.description;
    }

    public URI getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public Icon getIcon() {
        if (this.awtIcon != null) {
            return this.awtIcon;
        }
        if (this.icon == null) {
            return null;
        }
        Icon awtIcon = AWTSWTImageUtils.imageDescriptor2awtIcon((ImageDescriptor)this.icon);
        return awtIcon;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.icon != null) {
            return this.icon;
        }
        Icon icon2 = this.getIcon();
        if (icon2 == null) {
            return null;
        }
        return AWTSWTImageUtils.awtIcon2ImageDescriptor((Icon)icon2);
    }

    public ReferencedEnvelope getBounds() {
        return this.bounds;
    }

    public CoordinateReferenceSystem getCRS() {
        if (this.getBounds() == null) {
            return null;
        }
        return this.getBounds().getCoordinateReferenceSystem();
    }
}

