/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveManager;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.widgets.Display;

public abstract class IGeoResource
implements IResolve {
    protected static IGeoResourceInfo INFO_UNAVAILABLE = new IGeoResourceInfo();
    protected IService service = null;
    protected volatile IGeoResourceInfo info = null;

    @Override
    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (adaptee == null) {
            throw new NullPointerException("No adaptor specified");
        }
        if (adaptee.isAssignableFrom(IGeoResourceInfo.class)) {
            return adaptee.cast(this.getInfo(monitor));
        }
        if (adaptee.isAssignableFrom(IService.class)) {
            return adaptee.cast(this.service(monitor));
        }
        if (adaptee.isAssignableFrom(IServiceInfo.class)) {
            try {
                monitor.beginTask("service info", 100);
                IService service = this.service((IProgressMonitor)new SubProgressMonitor(monitor, 40));
                if (service != null) {
                    IServiceInfo info = service.getInfo((IProgressMonitor)new SubProgressMonitor(monitor, 60));
                    T t = adaptee.cast(info);
                    return t;
                }
            }
            finally {
                monitor.done();
            }
        }
        if (adaptee.isAssignableFrom(IGeoResource.class)) {
            monitor.done();
            return adaptee.cast(this);
        }
        if (adaptee.isAssignableFrom(this.getClass())) {
            return adaptee.cast(this);
        }
        IResolveManager rm = CatalogPlugin.getDefault().getResolveManager();
        if (rm.canResolve(this, adaptee)) {
            return rm.resolve(this, adaptee, monitor);
        }
        return null;
    }

    @Override
    public <T> boolean canResolve(Class<T> adaptee) {
        return adaptee != null && (adaptee.isAssignableFrom(IGeoResource.class) || adaptee.isAssignableFrom(IService.class) || adaptee.isAssignableFrom(this.getClass()) || adaptee.isAssignableFrom(IResolve.class) || CatalogPlugin.getDefault().getResolveManager().canResolve(this, adaptee));
    }

    protected abstract IGeoResourceInfo createInfo(IProgressMonitor var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGeoResourceInfo getInfo(IProgressMonitor monitor) throws IOException {
        if (this.info == null) {
            IGeoResource iGeoResource = this;
            synchronized (iGeoResource) {
                if (this.info == null) {
                    if (Display.getCurrent() != null && Platform.inDevelopmentMode()) {
                        throw new IllegalStateException("Lookup of getInfo not available from the display thread");
                    }
                    this.info = this.createInfo(monitor);
                    if (this.info == null) {
                        this.info = INFO_UNAVAILABLE;
                    }
                }
            }
        }
        if (this.info == INFO_UNAVAILABLE) {
            return null;
        }
        return this.info;
    }

    public Map<String, Serializable> getPersistentProperties() {
        ID id = this.getID();
        Map<String, Serializable> properties = this.service.getPersistentProperties(id);
        return properties;
    }

    @Override
    public IResolve parent(IProgressMonitor monitor) throws IOException {
        return this.service(monitor);
    }

    @Override
    public List<IResolve> members(IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof IGeoResource) {
            IGeoResource resource = (IGeoResource)other;
            if (this.getID() != null) {
                return this.getID().equals(resource.getID());
            }
        }
        return false;
    }

    public int hashCode() {
        int value = 31;
        if (this.getID() != null) {
            value += 31 + this.getID().hashCode();
        }
        return value += 31 + this.getClass().getName().hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String classname = this.getClass().getSimpleName();
        buf.append(classname);
        buf.append("(");
        ID ref = this.getID();
        buf.append(ref.labelResource());
        buf.append(")");
        return buf.toString();
    }

    @Override
    public abstract URL getIdentifier();

    @Override
    public ID getID() {
        return new ID(this.getIdentifier());
    }

    @Override
    public void dispose(IProgressMonitor monitor) {
    }

    @Override
    public String getTitle() {
        Map<String, Serializable> persistentProperties;
        String title = null;
        if (this.info != null && (title = this.info.getTitle()) != null && this.service != null) {
            persistentProperties = this.getPersistentProperties();
            persistentProperties.put("title", (Serializable)((Object)title));
        }
        if (title == null && this.service != null) {
            persistentProperties = this.getPersistentProperties();
            Serializable s = persistentProperties.get("title");
            title = s != null ? s.toString() : null;
        }
        return title;
    }

    public IService service(IProgressMonitor monitor) throws IOException {
        return this.service;
    }
}

