/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.ICatalogInfo;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IRepository;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveChangeListener;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.Messages;
import net.refractions.udig.ui.ErrorManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public abstract class ICatalog
extends IRepository {
    @Override
    public ICatalogInfo getInfo(IProgressMonitor monitor) throws IOException {
        return this.resolve(ICatalogInfo.class, monitor);
    }

    public abstract List<IResolve> find(URL var1, IProgressMonitor var2);

    public <T extends IResolve> List<T> find(Class<T> type, URL resourceId, IProgressMonitor monitor) {
        List<IResolve> resolves = this.find(resourceId, monitor);
        ArrayList<IResolve> result = new ArrayList<IResolve>();
        for (IResolve iResolve : resolves) {
            if (!type.isAssignableFrom(iResolve.getClass())) continue;
            IResolve desired = (IResolve)type.cast(iResolve);
            result.add(desired);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        String classname = this.getClass().getName();
        String name = classname.substring(classname.lastIndexOf(46) + 1);
        buf.append(name);
        buf.append("(");
        buf.append(this.getIdentifier());
        buf.append(")");
        return buf.toString();
    }

    public abstract void addCatalogListener(IResolveChangeListener var1);

    public abstract void removeCatalogListener(IResolveChangeListener var1);

    public abstract IGeoResource createTemporaryResource(Object var1) throws IllegalArgumentException;

    public abstract String[] getTemporaryDescriptorClasses();

    @Override
    public void dispose(IProgressMonitor monitor) {
        List<IResolve> members;
        monitor.beginTask(Messages.ICatalog_dispose, 100);
        try {
            members = this.members((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (Throwable e) {
            ErrorManager.get().displayException(e, "Error disposing members of catalog: " + this.getIdentifier(), "net.refractions.udig.catalog");
            return;
        }
        int steps = (int)(99.0 / (double)members.size());
        for (IResolve resolve : members) {
            try {
                SubProgressMonitor subProgressMonitor = new SubProgressMonitor(monitor, steps);
                resolve.dispose((IProgressMonitor)subProgressMonitor);
                subProgressMonitor.done();
            }
            catch (Throwable e) {
                ErrorManager.get().displayException(e, "Error disposing members of catalog: " + this.getIdentifier(), "net.refractions.udig.catalog");
            }
        }
    }

    public abstract List<IService> checkMembers(List<IService> var1);

    public abstract List<IService> checkNonMembers(List<IService> var1);

    public abstract List<IService> constructServices(URL var1, IProgressMonitor var2) throws IOException;

    public abstract List<IService> constructServices(Map<String, Serializable> var1, IProgressMonitor var2) throws IOException;
}

