/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Map;
import net.refractions.udig.catalog.ServiceExtension2;
import net.refractions.udig.catalog.internal.Messages;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStoreFactorySpi;

public abstract class AbstractDataStoreServiceExtension
implements ServiceExtension2 {
    @Override
    public final String reasonForFailure(Map<String, Serializable> params) {
        String parameterProcessingResult = this.processParameters(params, this.getDataStoreFactory().getParametersInfo());
        if (parameterProcessingResult != null) {
            return parameterProcessingResult;
        }
        String result = this.doOtherChecks(params);
        if (result != null) {
            return result;
        }
        return null;
    }

    protected String doOtherChecks(Map<String, Serializable> params) {
        return null;
    }

    protected abstract DataStoreFactorySpi getDataStoreFactory();

    @Override
    public abstract String reasonForFailure(URL var1);

    private String processParameters(Map<String, Serializable> params, DataAccessFactory.Param[] arrayParameters) {
        if (params == null) {
            return Messages.DataStoreServiceExtension_nullparams;
        }
        int i = 0;
        while (i < arrayParameters.length) {
            DataAccessFactory.Param param = arrayParameters[i];
            if (!params.containsKey(param.key)) {
                if (param.required) {
                    return String.valueOf(param.key) + Messages.DataStoreServiceExtension_missingKey + param.description;
                }
            } else {
                Object value;
                try {
                    value = param.lookUp(params);
                }
                catch (IOException iOException) {
                    return String.valueOf(Messages.DataStoreServiceExtension_theParam) + param.key + Messages.DataStoreServiceExtension_wrongType + param.type + Messages.DataStoreServiceExtension_butWas + params.get(param.key).getClass();
                }
                if (value == null) {
                    if (param.required) {
                        return String.valueOf(param.key) + Messages.DataStoreServiceExtension_nullParam + param.description;
                    }
                } else if (!param.type.isInstance(value)) {
                    return String.valueOf(Messages.DataStoreServiceExtension_theParam) + param.key + Messages.DataStoreServiceExtension_wrongType + param.type + Messages.DataStoreServiceExtension_butWas + params.get(param.key).getClass();
                }
            }
            ++i;
        }
        return null;
    }

    protected ParamInfo parseParamInfo(URL url) {
        String password;
        String username;
        String userInfo;
        String the_schema;
        String the_database;
        String host = url.getHost();
        if (host != null && !"".equals(host) && (host.endsWith("postgis.jdbc") || host.endsWith("jdbc.postgis"))) {
            host = host.substring(0, host.length() - 12);
        }
        Integer the_port = url.getPort() == -1 ? new Integer(5432) : new Integer(url.getPort());
        String path = url.getPath();
        if (path != null) {
            int endDB = path.indexOf(47, 1);
            the_database = path.substring(1, endDB);
            the_schema = path.substring(endDB + 1);
        } else {
            the_database = "";
            the_schema = null;
        }
        if (the_schema == null) {
            the_schema = "public";
        }
        String string = userInfo = url.getUserInfo() == null ? "" : url.getUserInfo();
        if (userInfo.contains(":")) {
            int indexOf = userInfo.indexOf(58, 1);
            username = userInfo.substring(0, indexOf);
            password = userInfo.substring(indexOf + 1, userInfo.length());
        } else {
            username = userInfo;
            password = "";
        }
        return new ParamInfo(url.getProtocol(), username, password, host, the_database, the_port, the_schema);
    }

    protected class ParamInfo {
        public String the_schema;
        public Integer the_port;
        public String host;
        public String the_database;
        public String password;
        public String username;
        public String protocol;

        public ParamInfo(String protocol, String username, String password, String host, String the_database, Integer the_port, String the_schema) {
            this.protocol = protocol;
            this.username = username;
            this.password = password;
            this.the_database = the_database;
            this.host = host;
            this.the_port = the_port;
            this.the_schema = the_schema;
        }
    }
}

