/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.render.wmt.basic;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.geotools.data.wms.WebMapServer;
import org.osgi.framework.BundleContext;

public class WMTPlugin
extends AbstractUIPlugin {
    public static final String ID = "net.refractions.udig.render.wmt.basic";
    private static WMTPlugin plugin;

    public WMTPlugin() {
        plugin = this;
    }

    public static WMTPlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(WebMapServer.class.getClassLoader());
            Logger logger = Logger.getLogger("org.geotools.data.ows");
            if (!this.isDebugging()) {
                logger.setLevel(Level.SEVERE);
            } else {
                logger.setLevel(Level.FINEST);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static void log(String message) {
        WMTPlugin.log(message, null);
    }

    public static void log(String message, Throwable exception) {
        WMTPlugin.getDefault().getLog().log((IStatus)new Status(1, ID, 0, message, exception));
    }

    public static final void trace(String message, Throwable e) {
        if (WMTPlugin.getDefault().isDebugging()) {
            if (message != null) {
                System.out.println(message);
            }
            if (e != null) {
                e.printStackTrace();
            }
        }
    }

    public static final void trace(String message) {
        WMTPlugin.trace(message, null);
    }

    public static boolean isDebugging(String trace) {
        return WMTPlugin.getDefault().isDebugging() && "true".equalsIgnoreCase(Platform.getDebugOption((String)trace));
    }

    public static void debug(String message, String trace) {
        WMTPlugin.debug(message, null, trace);
    }

    public static void debug(String message, Throwable e, String trace) {
        if (WMTPlugin.isDebugging(trace)) {
            if (message != null) {
                System.out.println(message);
            }
            if (e != null) {
                e.printStackTrace();
            }
        }
    }
}

