/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.shape;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import org.geotools.renderer.shape.AbstractShape;
import org.geotools.renderer.shape.SimpleGeometry;

public class MultiPointShape
extends AbstractShape
implements Shape {
    public MultiPointShape(SimpleGeometry geom) {
        super(geom);
    }

    @Override
    public PathIterator getPathIterator(final AffineTransform at) {
        return new PathIterator(){
            int currentPart = 0;

            @Override
            public int getWindingRule() {
                return 1;
            }

            @Override
            public boolean isDone() {
                return this.currentPart == MultiPointShape.this.geom.coords.length;
            }

            @Override
            public void next() {
                if (this.isDone()) {
                    return;
                }
                ++this.currentPart;
            }

            @Override
            public int currentSegment(float[] coords) {
                coords[0] = (float)MultiPointShape.this.geom.coords[this.currentPart][0];
                coords[1] = (float)MultiPointShape.this.geom.coords[this.currentPart][1];
                if (at != null) {
                    at.transform(coords, 0, coords, 0, 1);
                }
                return 0;
            }

            @Override
            public int currentSegment(double[] coords) {
                coords[0] = (float)MultiPointShape.this.geom.coords[this.currentPart][0];
                coords[1] = (float)MultiPointShape.this.geom.coords[this.currentPart][1];
                if (at != null) {
                    at.transform(coords, 0, coords, 0, 1);
                }
                return 0;
            }
        };
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }
}

