/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.model.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import net.refractions.udig.printing.model.AbstractBoxPrinter;
import net.refractions.udig.printing.model.Page;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IMemento;

public class RectangleEllipseBoxPrinter
extends AbstractBoxPrinter {
    private static final String LINEWIDTH_KEY = "linewidth";
    private static final String LINECOLOR_KEY = "linecolor";
    private static final String LINEALPHA_KEY = "linealpha";
    private static final String FILLCOLOR_KEY = "fillcolor";
    private static final String FILLALPHA_KEY = "fillalpha";
    private static final String SHAPETYPE_KEY = "shapetype";
    private static final String SCALEFACTOR_KEY = "scalefactor";
    public static final int RECTANGLE = 0;
    public static final int ROUNDEDRECTANGLE = 1;
    public static final int ELLIPSE = 2;
    private Color lineColor = Color.GRAY;
    private Color fillColor = Color.GRAY;
    private float lineWidth = 1.0f;
    private int lineAlpha = 255;
    private int fillAlpha = 128;
    private int type = 0;
    private float scaleFactor = Float.NaN;

    public RectangleEllipseBoxPrinter() {
    }

    public RectangleEllipseBoxPrinter(float scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    private float getScaleFactor() {
        Page page;
        if (Float.isNaN(this.scaleFactor) && (page = this.getBox().getPage()) != null) {
            this.scaleFactor = (float)page.getSize().width / (float)page.getPaperSize().height;
        }
        return this.scaleFactor;
    }

    private void setScaleFactor(float scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    @Override
    public void draw(Graphics2D graphics, IProgressMonitor monitor) {
        super.draw(graphics, monitor);
        int boxWidth = this.getBox().getSize().width - (int)this.lineWidth / 2;
        int boxHeight = this.getBox().getSize().height - (int)this.lineWidth / 2;
        int roundedEgde = 50;
        RectangularShape shape = null;
        shape = this.type == 1 ? new RoundRectangle2D.Double(0.0, 0.0, boxWidth, boxHeight, roundedEgde, roundedEgde) : (this.type == 2 ? new Ellipse2D.Double(0.0, 0.0, boxWidth, boxHeight) : new Rectangle2D.Double(0.0, 0.0, boxWidth, boxHeight));
        graphics.setPaint(new Color(this.fillColor.getRed(), this.fillColor.getGreen(), this.fillColor.getBlue(), this.fillAlpha));
        graphics.fill(shape);
        BasicStroke stroke = new BasicStroke(this.lineWidth);
        graphics.setStroke(stroke);
        graphics.setColor(new Color(this.lineColor.getRed(), this.lineColor.getGreen(), this.lineColor.getBlue(), this.lineAlpha));
        graphics.draw(shape);
    }

    @Override
    public void createPreview(Graphics2D graphics, IProgressMonitor monitor) {
        this.draw(graphics, monitor);
        this.setDirty(false);
    }

    @Override
    public void save(IMemento memento) {
        memento.putFloat(LINEWIDTH_KEY, this.lineWidth);
        memento.putString(LINECOLOR_KEY, this.color2String(this.lineColor));
        memento.putInteger(LINEALPHA_KEY, this.lineAlpha);
        memento.putString(FILLCOLOR_KEY, this.color2String(this.fillColor));
        memento.putInteger(FILLALPHA_KEY, this.fillAlpha);
        memento.putInteger(SHAPETYPE_KEY, this.type);
        memento.putFloat(SCALEFACTOR_KEY, this.getScaleFactor());
    }

    @Override
    public void load(IMemento memento) {
        this.lineWidth = memento.getFloat(LINEWIDTH_KEY).floatValue();
        this.lineColor = this.string2Color(memento.getString(LINECOLOR_KEY));
        this.lineAlpha = memento.getInteger(LINEALPHA_KEY);
        this.fillColor = this.string2Color(memento.getString(FILLCOLOR_KEY));
        this.fillAlpha = memento.getInteger(FILLALPHA_KEY);
        this.type = memento.getInteger(SHAPETYPE_KEY);
        this.setScaleFactor(memento.getFloat(SCALEFACTOR_KEY).floatValue());
    }

    private String color2String(Color color) {
        return String.valueOf(color.getRed()) + "," + color.getGreen() + "," + color.getBlue();
    }

    private Color string2Color(String string) {
        String[] split = string.split(",");
        Color color = new Color(Integer.parseInt(split[0].trim()), Integer.parseInt(split[1].trim()), Integer.parseInt(split[2].trim()));
        return color;
    }

    @Override
    public String getExtensionPointID() {
        return "net.refractions.udig.printing.ui.standardBoxes";
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    @Override
    public Color getFillColor() {
        return this.fillColor;
    }

    @Override
    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public int getLineAlpha() {
        return this.lineAlpha;
    }

    public void setLineAlpha(int lineAlpha) {
        this.lineAlpha = lineAlpha;
    }

    public int getFillAlpha() {
        return this.fillAlpha;
    }

    public void setFillAlpha(int fillAlpha) {
        this.fillAlpha = fillAlpha;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }
}

