/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.model.impl;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.printing.model.AbstractBoxPrinter;
import net.refractions.udig.printing.model.Page;
import net.refractions.udig.ui.graphics.AWTSWTImageUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;

public class LabelBoxPrinter
extends AbstractBoxPrinter {
    public static final int INSET = 10;
    private static final String SIZE_KEY = "size";
    private static final String STYLE_KEY = "style";
    private static final String FONT_NAME_KEY = "fontName";
    private static final String FONT_COLOR_KEY = "fontCOLOR";
    private static final String FONT_SCALE_FACTOR = "fontScaleFActor";
    private static final String LABEL_KEY = "label";
    private static final String HORIZ_ALIGN_KEY = "horizontalAlignment";
    private String text = "Set Text";
    private int padding;
    String preview;
    private int horizontalAlignment = 16384;
    private int verticalAlignment = 128;
    private boolean wrap;
    private Color fontColor = Color.BLACK;
    private Font originalFont;
    private Font scaledFont;
    private boolean inPreviewMode = false;
    private float scaleFactor = Float.NaN;

    public LabelBoxPrinter() {
        this.padding = 0;
    }

    public LabelBoxPrinter(int padding) {
        this.padding = padding;
    }

    public LabelBoxPrinter(float scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    private float getScaleFactor() {
        Page page;
        if (Float.isNaN(this.scaleFactor) && (page = this.getBox().getPage()) != null) {
            this.scaleFactor = (float)page.getSize().width / (float)page.getPaperSize().height;
        }
        return this.scaleFactor;
    }

    private void setScaleFactor(float scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public int getPadding() {
        return this.padding;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.setDirty(true);
    }

    @Override
    public void draw(Graphics2D graphics, IProgressMonitor monitor) {
        super.draw(graphics, monitor);
        int boxWidth = this.getBox().getSize().width;
        int boxHeight = this.getBox().getSize().height;
        int availableWidth = boxWidth - 2 * this.padding;
        int availableHeight = boxHeight - 2 * this.padding;
        Font drawFont = null;
        drawFont = this.inPreviewMode ? this.scaledFont : this.originalFont;
        if (drawFont == null) {
            this.setDefaultFont();
            drawFont = this.inPreviewMode ? this.scaledFont : this.originalFont;
        }
        if (drawFont != null && this.text != null) {
            int y;
            graphics.setFont(drawFont);
            graphics.setColor(this.fontColor);
            int spaceBetweenLines = (int)((float)drawFont.getSize() / 4.0f);
            List<String> lines = this.splitIntoLines(this.text, availableWidth, graphics, this.getWrap());
            switch (this.verticalAlignment) {
                case 0x1000000: {
                    int textHeight = this.textHeight(lines, spaceBetweenLines, graphics);
                    y = this.padding + (availableHeight - textHeight) / 2;
                    break;
                }
                default: {
                    y = this.padding;
                }
            }
            int i = 0;
            while (i < lines.size()) {
                int x;
                String line = lines.get(i);
                Rectangle2D lineBounds = graphics.getFontMetrics().getStringBounds(line, graphics);
                switch (this.horizontalAlignment) {
                    case 0x1000000: {
                        x = (int)(((double)boxWidth - lineBounds.getWidth()) / 2.0);
                        break;
                    }
                    case 131072: {
                        x = (int)((double)boxWidth - lineBounds.getWidth()) - this.padding;
                        break;
                    }
                    default: {
                        x = this.padding;
                    }
                }
                y = i == 0 ? (y += drawFont.getSize()) : (int)((double)y + lineBounds.getHeight());
                graphics.drawString(line, x, y);
                y += spaceBetweenLines;
                ++i;
            }
        }
    }

    private void setDefaultFont() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                FontData data = Display.getDefault().getSystemFont().getFontData()[0];
                data.setHeight(24);
                data.setStyle(1);
                Font font = AWTSWTImageUtils.swtFontToAwt((FontData)data);
                LabelBoxPrinter.this.setFont(font);
            }
        });
    }

    private int textHeight(List<String> lines, int spaceBetweenLines, Graphics2D graphics) {
        int height = 0;
        int i = 0;
        while (i < lines.size()) {
            if (i > 0) {
                height += spaceBetweenLines;
            }
            String line = lines.get(i);
            Rectangle2D lineBounds = graphics.getFontMetrics().getStringBounds(line, graphics);
            height = (int)((double)height + lineBounds.getHeight());
            ++i;
        }
        return height;
    }

    private List<String> splitIntoLines(String text, int availableWidth, Graphics2D graphics, boolean wrap) {
        ArrayList<String> lines = new ArrayList<String>();
        if (!wrap) {
            lines.add(text);
            return lines;
        }
        String[] words = text.split(" ");
        String currentLine = "";
        int i = 0;
        while (i < words.length) {
            String tryLine = currentLine.equals("") ? words[i] : String.valueOf(currentLine) + " " + words[i];
            Rectangle2D lineBounds = graphics.getFontMetrics().getStringBounds(tryLine, graphics);
            if (lineBounds.getWidth() > (double)availableWidth) {
                lines.add(currentLine);
                currentLine = words[i];
            } else {
                currentLine = tryLine;
            }
            ++i;
        }
        if (!currentLine.equals("")) {
            lines.add(currentLine);
        }
        return lines;
    }

    @Override
    public void createPreview(Graphics2D graphics, IProgressMonitor monitor) {
        this.inPreviewMode = true;
        this.draw(graphics, monitor);
        this.preview = this.getText();
        this.setDirty(false);
        this.inPreviewMode = false;
    }

    @Override
    public void save(IMemento memento) {
        memento.putString(LABEL_KEY, this.text);
        memento.putInteger(HORIZ_ALIGN_KEY, this.horizontalAlignment);
        if (this.originalFont != null) {
            memento.putString(FONT_NAME_KEY, this.originalFont.getFamily());
            memento.putInteger(STYLE_KEY, this.originalFont.getStyle());
            memento.putInteger(SIZE_KEY, this.originalFont.getSize());
            memento.putFloat(FONT_SCALE_FACTOR, this.getScaleFactor());
        }
        if (this.fontColor != null) {
            StringBuilder clrString = new StringBuilder();
            clrString.append(this.fontColor.getRed());
            clrString.append(",");
            clrString.append(this.fontColor.getGreen());
            clrString.append(",");
            clrString.append(this.fontColor.getBlue());
            memento.putString(FONT_COLOR_KEY, clrString.toString());
        }
    }

    @Override
    public void load(IMemento memento) {
        this.text = memento.getString(LABEL_KEY);
        this.horizontalAlignment = memento.getInteger(HORIZ_ALIGN_KEY);
        this.setScaleFactor(memento.getFloat(FONT_SCALE_FACTOR).floatValue());
        String family = memento.getString(FONT_NAME_KEY);
        if (family != null) {
            int size = memento.getInteger(SIZE_KEY);
            int style = memento.getInteger(STYLE_KEY);
            this.originalFont = new Font(family, style, size);
            int resizedValue = (int)((float)size * this.getScaleFactor());
            if (resizedValue < 4) {
                resizedValue = 4;
            }
            this.scaledFont = new Font(family, style, resizedValue);
            String colorString = memento.getString(FONT_COLOR_KEY);
            if (colorString != null) {
                Color clr;
                String[] colorSplit = colorString.split(",");
                this.fontColor = clr = new Color(Integer.parseInt(colorSplit[0]), Integer.parseInt(colorSplit[1]), Integer.parseInt(colorSplit[2]));
            }
        }
    }

    @Override
    public String getExtensionPointID() {
        return "net.refractions.udig.printing.ui.standardBoxes";
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(String.class)) {
            return this.text;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public void setFont(Font newFont) {
        this.originalFont = newFont;
        int resizedValue = (int)((float)this.originalFont.getSize() * this.getScaleFactor());
        if (resizedValue < 4) {
            resizedValue = 4;
        }
        this.scaledFont = new Font(newFont.getName(), newFont.getStyle(), resizedValue);
        this.setDirty(true);
    }

    public Font getFont() {
        return this.originalFont;
    }

    public void setHorizontalAlignment(int newAlignment) {
        if (newAlignment != 16384 && newAlignment != 0x1000000 && newAlignment != 131072) {
            throw new IllegalArgumentException("An illegal option was provided");
        }
        this.horizontalAlignment = newAlignment;
        this.setDirty(true);
    }

    public void setVerticalAlignment(int newAlignment) {
        if (newAlignment != 128 && newAlignment != 0x1000000) {
            throw new IllegalArgumentException("An illegal option was provided");
        }
        this.verticalAlignment = newAlignment;
        this.setDirty(true);
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    public boolean getWrap() {
        return this.wrap;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    public static String getHORIZ_ALIGN_KEY() {
        return HORIZ_ALIGN_KEY;
    }
}

