/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.validator;

import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.behaviour.IEditValidator;
import net.refractions.udig.tools.edit.support.EditUtils;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;

public class ValidHoleValidator
implements IEditValidator {
    @Override
    public String isValid(EditToolHandler handler, MapMouseEvent event, EventType type) {
        PrimitiveShape shell = handler.getCurrentGeom().getShell();
        PrimitiveShape hole = handler.getCurrentShape();
        assert (hole != shell);
        Point newPoint = Point.valueOf(event.x, event.y);
        int lastPointIndex = hole.getNumPoints() - 1;
        if (hole.getNumPoints() > 2 && EditUtils.instance.intersection(hole.getPoint(lastPointIndex), newPoint, hole, 0, lastPointIndex)) {
            return Messages.ValidHoleValidator_selfIntersection;
        }
        if (!shell.contains(newPoint, true)) {
            return Messages.ValidHoleValidator_outsideShell;
        }
        for (PrimitiveShape hole2 : shell.getEditGeom().getHoles()) {
            if (hole == hole2 || !hole2.contains(newPoint, true)) continue;
            return Messages.ValidHoleValidator_holeOverlap;
        }
        return null;
    }
}

