/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.validator;

import java.util.List;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.behaviour.IEditValidator;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.EditUtils;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;

public class LegalShapeValidator
implements IEditValidator {
    String holeOverlap = Messages.LegalShapeValidator_holeOverlap;
    String holeOutside = Messages.LegalShapeValidator_holeOutside;

    @Override
    public String isValid(EditToolHandler handler, MapMouseEvent event, EventType type) {
        EditBlackboard editBlackboard = handler.getEditBlackboard(handler.getEditLayer());
        List<EditGeom> geoms = editBlackboard.getGeoms();
        for (EditGeom geom : geoms) {
            String message = this.test(geom);
            if (message == null) continue;
            return message;
        }
        return null;
    }

    private String test(EditGeom geom) {
        String message = this.testSelfIntersection(geom);
        if (message != null) {
            return message;
        }
        message = this.testHoleIntersection(geom);
        if (message != null) {
            return message;
        }
        message = this.testShellContainsHoles(geom);
        if (message != null) {
            return message;
        }
        return message;
    }

    private String testSelfIntersection(EditGeom geom) {
        if (EditUtils.instance.selfIntersection(geom.getShell())) {
            return Messages.LegalShapeValidator_shellIntersection;
        }
        for (PrimitiveShape hole : geom.getHoles()) {
            if (!EditUtils.instance.selfIntersection(hole)) continue;
            return Messages.LegalShapeValidator_holeIntersection;
        }
        return null;
    }

    private String testHoleIntersection(EditGeom geom) {
        for (PrimitiveShape hole : geom.getHoles()) {
            for (PrimitiveShape hole2 : geom.getHoles()) {
                if (hole == hole2 || !hole.overlap(hole2, true, false)) continue;
                return Messages.LegalShapeValidator_holeOverlap;
            }
        }
        return null;
    }

    private String testShellContainsHoles(EditGeom geom) {
        for (PrimitiveShape shape : geom.getHoles()) {
            for (Point point : shape) {
                if (geom.getShell().contains(point, true, true)) continue;
                return Messages.LegalShapeValidator_holeOutside;
            }
        }
        return null;
    }
}

