/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.support;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.ClosestEdge;
import net.refractions.udig.tools.edit.support.CoordResolvingList;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.EditUtils;
import net.refractions.udig.tools.edit.support.LazyCoord;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PointCoordCalculator;
import net.refractions.udig.tools.edit.support.PrimitiveShapeIterator;
import net.refractions.udig.tools.edit.support.ShapeType;

public class PrimitiveShape
implements Iterable<Point>,
Shape {
    private Map<Point, List<PointCoordMap>> pointsToModel = new HashMap<Point, List<PointCoordMap>>();
    private Map<LazyCoord, PointCoordMap> coordsToModel = new HashMap<LazyCoord, PointCoordMap>();
    private List<PointCoordMap> points = new ArrayList<PointCoordMap>();
    private final List<LazyCoord> coordinates = new ArrayList<LazyCoord>();
    private final AtomicReference<Mutator> mutable = new AtomicReference();
    private final EditGeom owner;
    private Envelope envelope;
    String type = "SHELL";

    public PrimitiveShape(EditGeom owner) {
        this.owner = owner;
    }

    public PrimitiveShape(PrimitiveShape shape) {
        this(shape.owner);
        this.points.addAll(shape.points);
        for (LazyCoord coord : shape.coordinates) {
            this.coordinates.add(new LazyCoord(coord));
        }
    }

    public int getNumPoints() {
        return this.points.size();
    }

    public Point getPoint(int i) {
        return this.points.get((int)i).point;
    }

    public int getNumCoords() {
        return this.coordinates.size();
    }

    public Coordinate getCoord(int i) {
        LazyCoord coord = this.coordinates.get(i);
        Point point = this.coordsToModel.get((Object)((Object)coord)).point;
        return coord.get(point);
    }

    public String toString() {
        if (this.points.size() == 0) {
            return "[]";
        }
        StringBuffer buffer = new StringBuffer(String.valueOf(this.type) + "[");
        for (PointCoordMap point : this.points) {
            buffer.append(point.point.toString());
            buffer.append(",");
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append("]");
        return buffer.toString();
    }

    Mutator getMutator() {
        if (this.mutable.get() == null) {
            this.mutable.set(new Mutator());
        }
        return this.mutable.get();
    }

    public EditGeom getEditGeom() {
        return this.owner;
    }

    public EditBlackboard getEditBlackboard() {
        return this.owner.getEditBlackboard();
    }

    @Override
    public Iterator<Point> iterator() {
        final PointCoordMap[] array = this.points.toArray(new PointCoordMap[this.points.size()]);
        return new Iterator<Point>(){
            int i = -1;

            @Override
            public boolean hasNext() {
                return this.i < array.length - 1;
            }

            @Override
            public Point next() {
                ++this.i;
                return array[this.i].point;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("This is iterator does not allow modification");
            }
        };
    }

    public Iterator<Coordinate> coordIterator() {
        return this.getMutator().coordIterator();
    }

    public Coordinate[] coordArray() {
        Coordinate[] array = new Coordinate[this.coordinates.size()];
        Iterator<Coordinate> iter = this.coordIterator();
        int i = 0;
        while (i < array.length) {
            array[i] = iter.next();
            ++i;
        }
        return array;
    }

    public boolean hasVertex(Point p) {
        return this.pointsToModel.containsKey(p);
    }

    boolean hasVertex(Point p, LazyCoord coord) {
        List<PointCoordMap> list = this.pointsToModel.get(p);
        if (list == null) {
            return false;
        }
        for (PointCoordMap map : list) {
            if (map.coords == null) {
                return false;
            }
            for (LazyCoord coord2 : map.coords) {
                if (coord2 != coord) continue;
                return true;
            }
        }
        return false;
    }

    public ClosestEdge getClosestEdge(Point click, boolean treatUnknownAsPolygon) {
        int endIndex;
        int startIndex;
        Point coord1;
        int lastIndex;
        if (this.getNumPoints() == 0) {
            return null;
        }
        if (this.getEditGeom().getShapeType() == ShapeType.UNKNOWN && treatUnknownAsPolygon || this.getEditGeom().getShapeType() == ShapeType.POLYGON) {
            lastIndex = this.getNumPoints() - 1;
            coord1 = this.getPoint(lastIndex);
            startIndex = 0;
            endIndex = this.getNumPoints() - 1;
        } else if (this.getEditGeom().getShapeType() == ShapeType.UNKNOWN && !treatUnknownAsPolygon || this.getEditGeom().getShapeType() == ShapeType.LINE) {
            lastIndex = 0;
            coord1 = this.getPoint(lastIndex);
            startIndex = 1;
            endIndex = this.getNumPoints() - 1;
        } else {
            return null;
        }
        double mindist = Double.MAX_VALUE;
        int prev = -1;
        Point closestPoint = null;
        int i = startIndex;
        while (i <= endIndex) {
            Point coord2 = this.getPoint(i);
            try {
                int y;
                int x;
                double dist;
                Point point = EditUtils.instance.closestPointOnEdge(coord1, coord2, click);
                if (point != null && (dist = Math.sqrt((x = click.getX() - point.getX()) * x + (y = click.getY() - point.getY()) * y)) < mindist) {
                    mindist = dist;
                    prev = lastIndex;
                    closestPoint = point;
                }
            }
            finally {
                coord1 = coord2;
                lastIndex = i;
            }
            ++i;
        }
        if (closestPoint == null) {
            return null;
        }
        return new ClosestEdge(mindist, prev, closestPoint, this);
    }

    @Override
    public Rectangle getBounds() {
        int minx = Integer.MAX_VALUE;
        int maxx = Integer.MIN_VALUE;
        int miny = Integer.MAX_VALUE;
        int maxy = Integer.MIN_VALUE;
        for (Point point : this.getMutator()) {
            if (point.getX() < minx) {
                minx = point.getX();
            }
            if (point.getX() > maxx) {
                maxx = point.getX();
            }
            if (point.getY() < miny) {
                miny = point.getY();
            }
            if (point.getY() <= maxy) continue;
            maxy = point.getY();
        }
        return new Rectangle(minx, miny, maxx - minx, maxy - miny);
    }

    public boolean contains(Point point, boolean treatUnknownGeomsAsPolygon) {
        return this.contains(point, treatUnknownGeomsAsPolygon, false);
    }

    public boolean contains(Point point, boolean treatUnknownGeomsAsPolygon, boolean ignoreVertexRadius) {
        if (this.points.size() == 0) {
            return false;
        }
        int vertexRadius = ignoreVertexRadius ? 1 : PreferenceUtil.instance().getVertexRadius();
        if (this.points.size() == 1) {
            int y;
            Point click = this.points.get((int)0).point;
            int x = click.getX() - point.getX();
            double dist = Math.sqrt(x * x + (y = click.getY() - point.getY()) * y);
            return dist < (double)vertexRadius;
        }
        Point overVertex = this.getEditBlackboard().overVertex(point, vertexRadius);
        if (overVertex != null && this.pointsToModel.containsKey(overVertex)) {
            return true;
        }
        ClosestEdge edge = this.getClosestEdge(point, treatUnknownGeomsAsPolygon);
        if (edge != null && edge.getDistanceToEdge() < (double)vertexRadius) {
            return true;
        }
        PrimitiveShapeIterator iter = PrimitiveShapeIterator.getPathIterator(this);
        iter.setPolygon(this.isPolygon(treatUnknownGeomsAsPolygon));
        GeneralPath path = new GeneralPath();
        path.append(iter, false);
        return path.contains(point.getX(), point.getY());
    }

    @Override
    public Rectangle2D getBounds2D() {
        return null;
    }

    @Override
    public boolean contains(double x, double y) {
        return this.contains(Point.valueOf((int)x, (int)y), true);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(Point.valueOf((int)p.getX(), (int)p.getY()), true);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return false;
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return false;
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return false;
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return false;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return PrimitiveShapeIterator.getPathIterator(this);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return PrimitiveShapeIterator.getPathIterator(this);
    }

    public List<Coordinate> getCoordsAt(int i) {
        PointCoordMap bag = this.points.get(i);
        return new CoordResolvingList(bag.coords, bag.point);
    }

    public List<Coordinate> getCoordsAt(Point point) {
        return new CoordResolvingList(this.getMutator().getLazyCoordsAt(point), point);
    }

    public int getAssociatedPointIndex(int coordIndex) {
        return this.points.indexOf(this.coordsToModel.get((Object)this.coordinates.get(coordIndex)));
    }

    public boolean hasVertex(Coordinate start) {
        for (LazyCoord coord : this.coordinates) {
            if (!coord.get(this.coordsToModel.get((Object)((Object)coord)).point).equals((Object)start)) continue;
            return true;
        }
        return false;
    }

    public void assertValid() {
        if (!EditPlugin.isDebugging("net.refractions.udig.tools.edit/debug/assertions")) {
            return;
        }
        if (this.getNumCoords() == 0 && this.getNumPoints() != 0 || this.getNumCoords() != 0 && this.getNumPoints() == 0) {
            throw new AssertionError((Object)("Num Coords=" + this.getNumCoords() + " NumPoints=" + this.getNumPoints()));
        }
        if (this.getNumCoords() < 1) {
            return;
        }
        for (LazyCoord lz : this.coordinates) {
            if (!this.coordsToModel.containsKey((Object)lz)) {
                throw new AssertionError((Object)((Object)((Object)lz) + " should be in coordsToModel but isn't"));
            }
            PointCoordMap bag = this.coordsToModel.get((Object)lz);
            Point findVertex = bag.point;
            if (findVertex == null) {
                throw new AssertionError((Object)(bag.point + " should equal findVertex(getEditBlackboard().toPoint(lz.get(bag.point)), snappingRadius, false)"));
            }
            boolean found = false;
            for (LazyCoord lz2 : bag.coords) {
                if (lz2 != lz) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new AssertionError((Object)((Object)((Object)lz) + " is not in the mapped bag " + bag));
            }
            if (this.getEditBlackboard().coordMapping.containsKey(bag.point)) {
                found = false;
                List<LazyCoord> list = this.getEditBlackboard().coordMapping.get(bag.point);
                for (LazyCoord lz2 : list) {
                    if (lz2 != lz) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new AssertionError((Object)((Object)((Object)lz) + " is not in editblackboard's coordMapping"));
                }
                continue;
            }
            throw new AssertionError((Object)(bag.point + " should be in the blackboard but isn't"));
        }
        for (PointCoordMap b : this.points) {
            for (LazyCoord coordinate : b.coords) {
                if (!this.coordinates.contains((Object)coordinate)) {
                    throw new AssertionError((Object)((Object)((Object)coordinate) + " is not in the list of coordinate but it should be"));
                }
                if (!this.coordsToModel.containsKey((Object)coordinate)) {
                    throw new AssertionError((Object)((Object)((Object)coordinate) + " is not in coordsToModel map"));
                }
                if (!this.pointsToModel.containsKey(b.point)) {
                    throw new AssertionError((Object)(b.point + " is not in pointsToModel map"));
                }
            }
            if (!this.getEditBlackboard().coordMapping.get(b.point).containsAll(b.coords)) {
                throw new AssertionError((Object)"Not all coordinates in bags are in editblackboard");
            }
            if (!this.getEditBlackboard().geomMapping.get(b.point).contains(this.getEditGeom())) {
                throw new AssertionError((Object)("EditGeom is not mapped to " + b.point + " in edit blackboard's geomMapping"));
            }
        }
        EditPlugin.trace("net.refractions.udig.tools.edit/debug/assertions", "shape is valid", null);
    }

    public boolean contains(Coordinate startCoord, boolean treatUnknownGeomsAsPolygon) {
        int i = 0;
        while (i < this.getNumCoords() - 1) {
            Coordinate intersection = EditUtils.instance.closestCoordinateOnEdge(this.getCoord(i), this.getCoord(i + 1), startCoord);
            if (intersection != null && intersection.equals((Object)startCoord)) {
                return true;
            }
            ++i;
        }
        PrimitiveShapeIterator iter = PrimitiveShapeIterator.getPathIterator(this);
        iter.setPolygon(treatUnknownGeomsAsPolygon);
        Shape s = iter.toShape();
        return s.contains(startCoord.x, startCoord.y);
    }

    public Point overVertex(Point location, int radius) {
        return this.overVertex(location, radius, false);
    }

    public synchronized Point overVertex(Point location, int radius, boolean ignore) {
        List<PointCoordMap> list = this.pointsToModel.get(location);
        if (!ignore && list != null && !list.isEmpty()) {
            return location;
        }
        int i = 1;
        while (i <= radius) {
            Point result = this.findVertex(location, i);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private Point findVertex(Point location, int i) {
        List<PointCoordMap> list;
        Point temp;
        int maxX = location.getX() + i;
        int maxY = location.getY() + i;
        int minX = location.getX() - i;
        int minY = location.getY() - i;
        int x = minX;
        while (x <= maxX) {
            temp = Point.valueOf(x, minY);
            list = this.pointsToModel.get(temp);
            if (list != null && list.size() > 0) {
                return temp;
            }
            ++x;
        }
        int y = minY + 1;
        while (y <= maxY) {
            temp = Point.valueOf(maxX, y);
            list = this.pointsToModel.get(temp);
            if (list != null && list.size() > 0) {
                return temp;
            }
            ++y;
        }
        x = maxX - 1;
        while (x >= minX) {
            temp = Point.valueOf(x, maxY);
            list = this.pointsToModel.get(temp);
            if (list != null && list.size() > 0) {
                return temp;
            }
            --x;
        }
        y = maxY - 1;
        while (y >= minY) {
            temp = Point.valueOf(minX, y);
            list = this.pointsToModel.get(temp);
            if (list != null && list.size() > 0) {
                return temp;
            }
            --y;
        }
        return null;
    }

    public Envelope getEnvelope() {
        if (this.envelope == null) {
            this.envelope = new Envelope();
            int i = 0;
            while (i < this.getNumCoords()) {
                this.envelope.expandToInclude(this.getCoord(i));
                ++i;
            }
        }
        return this.envelope;
    }

    public boolean overlap(PrimitiveShape shape2, boolean treatUnknownAsPolygon, boolean acceptTouches) {
        if (this.getNumPoints() == 0) {
            return false;
        }
        if (shape2.getNumPoints() == 0) {
            return false;
        }
        if (this.getNumPoints() == 1) {
            return shape2.contains(this.getPoint(0), treatUnknownAsPolygon, true) && this.isAcceptableIntersection(shape2, this.getPoint(0), acceptTouches);
        }
        if (shape2.getNumPoints() == 1) {
            return this.contains(shape2.getPoint(0), treatUnknownAsPolygon, true) && this.isAcceptableIntersection(this, shape2.getPoint(0), acceptTouches);
        }
        PrimitiveShapeIterator piter = PrimitiveShapeIterator.getPathIterator(this);
        piter.setPolygon(this.isPolygon(treatUnknownAsPolygon));
        Shape s = piter.toShape();
        PrimitiveShapeIterator piter2 = PrimitiveShapeIterator.getPathIterator(shape2);
        piter2.setPolygon(this.isPolygon(treatUnknownAsPolygon));
        Shape s2 = piter2.toShape();
        for (Point point : shape2) {
            if (!s.contains(point.getX(), point.getY()) || !this.isAcceptableIntersection(this, point, acceptTouches)) continue;
            return true;
        }
        Iterator<Point> iter = this.iterator();
        Point last = iter.next();
        while (iter.hasNext()) {
            Point current = iter.next();
            if (s2.contains(last.getX(), last.getY()) && this.isAcceptableIntersection(shape2, last, acceptTouches)) {
                return true;
            }
            if (this.edgeIntersect(last, current, shape2, acceptTouches)) {
                return true;
            }
            last = current;
        }
        return this.isPolygon(treatUnknownAsPolygon) && this.edgeIntersect(this.getPoint(this.getNumPoints() - 1), this.getPoint(0), shape2, acceptTouches);
    }

    private boolean edgeIntersect(Point last, Point current, PrimitiveShape shape2, boolean acceptTouches) {
        Iterator<Point> iter2 = shape2.iterator();
        Point last2 = iter2.next();
        while (iter2.hasNext()) {
            Point current2 = iter2.next();
            Point intersection = EditUtils.instance.intersectingLines(last, current, last2, current2);
            if (intersection != null && this.isAcceptableIntersection(intersection, last2, current2, acceptTouches) && this.isAcceptableIntersection(intersection, last, current, acceptTouches)) {
                return true;
            }
            last2 = current2;
        }
        return false;
    }

    private boolean isAcceptableIntersection(PrimitiveShape shape, Point point, boolean acceptTouches) {
        if (shape.getNumPoints() == 1 && point.equals(shape.getPoint(0))) {
            return acceptTouches;
        }
        Envelope envelope2 = new Envelope((double)point.getX() - 0.1, (double)point.getX() + 0.1, (double)point.getY() - 0.1, (double)point.getY() + 0.1);
        if (EditUtils.instance.overEdgePixelPrecision(shape, envelope2)) {
            return acceptTouches;
        }
        return true;
    }

    private boolean isAcceptableIntersection(Point intersection, Point endPoint1, Point endPoint2, boolean acceptTouches) {
        if (intersection.equals(endPoint1) || intersection.equals(endPoint2)) {
            return acceptTouches;
        }
        return true;
    }

    private boolean isPolygon(boolean treatUnknownAsPolygon) {
        return this.owner.getShapeType() == ShapeType.POLYGON || this.owner.getShapeType() == ShapeType.UNKNOWN && treatUnknownAsPolygon;
    }

    public List<Point> getPoints() {
        ArrayList<Point> result = new ArrayList<Point>();
        for (PointCoordMap point : this.points) {
            result.add(point.point);
        }
        return result;
    }

    class Mutator
    implements Iterable<Point> {
        Mutator() {
        }

        public void addPoint(Point p, List<Coordinate> coords) {
            this.addPoint(PrimitiveShape.this.points.size(), p, coords);
        }

        public List<LazyCoord> addPoint(int i, Point p, List<Coordinate> coords) {
            int index;
            List<Coordinate> c = coords;
            PointCoordMap bag = this.getBag(i, p);
            if (c == null) {
                c = Collections.singletonList(PrimitiveShape.this.getEditBlackboard().toCoord(p));
            }
            List<LazyCoord> lazyCoords = this.addAll(bag.coords.size(), bag.coords, p, c);
            ArrayList<PointCoordMap> bags = (ArrayList<PointCoordMap>)PrimitiveShape.this.pointsToModel.get(p);
            if (bags == null) {
                bags = new ArrayList<PointCoordMap>();
                PrimitiveShape.this.pointsToModel.put(p, bags);
            }
            if (!bags.contains(bag)) {
                bags.add(bag);
            }
            if (PrimitiveShape.this.coordinates.size() == 0) {
                index = 0;
            } else if (bag.coords.size() > 1) {
                LazyCoord lazyCoord = bag.coords.get(bag.coords.size() - 2);
                index = PrimitiveShape.this.coordinates.indexOf((Object)lazyCoord) + 1;
            } else if (i == 0) {
                index = 0;
            } else {
                PointCoordMap lastbag = (PointCoordMap)PrimitiveShape.this.points.get(i - 1);
                if (lastbag == bag) {
                    lastbag = (PointCoordMap)PrimitiveShape.this.points.get(i - 2);
                }
                index = PrimitiveShape.this.coordinates.indexOf((Object)lastbag.coords.get(lastbag.coords.size() - 1)) + 1;
            }
            for (LazyCoord coord : lazyCoords) {
                PrimitiveShape.this.coordinates.add(index++, coord);
                PrimitiveShape.this.coordsToModel.put(coord, bag);
            }
            if (!((PrimitiveShape)PrimitiveShape.this).owner.initializing) {
                PrimitiveShape.this.getEditGeom().setChanged(true);
            }
            return lazyCoords;
        }

        private List<LazyCoord> addAll(int i, List<LazyCoord> coordinates, Point p, List<Coordinate> c) {
            int j = i;
            EditBlackboard bb = PrimitiveShape.this.getEditBlackboard();
            ArrayList<LazyCoord> coords = new ArrayList<LazyCoord>(c.size());
            for (Coordinate coordinate : c) {
                LazyCoord lazyCoord = new LazyCoord(p, coordinate, bb);
                coordinates.add(j++, lazyCoord);
                coords.add(lazyCoord);
            }
            return coords;
        }

        private PointCoordMap getBag(int i, Point p) {
            if (i > 0 && i <= PrimitiveShape.this.points.size()) {
                if (((PointCoordMap)((PrimitiveShape)PrimitiveShape.this).points.get((int)(i - 1))).point.equals(p)) {
                    return (PointCoordMap)PrimitiveShape.this.points.get(i - 1);
                }
                if (PrimitiveShape.this.points.size() > i + 1 && ((PointCoordMap)((PrimitiveShape)PrimitiveShape.this).points.get((int)(i + 1))).point.equals(p)) {
                    return (PointCoordMap)PrimitiveShape.this.points.get(i + 1);
                }
            }
            PointCoordMap bag = new PointCoordMap(p);
            PrimitiveShape.this.points.add(i, bag);
            return bag;
        }

        public void addCoordinate(int i, Coordinate c) {
            Point p = PrimitiveShape.this.getEditBlackboard().toPoint(c);
            PrimitiveShape.this.coordinates.add(i, new LazyCoord(p, c, PrimitiveShape.this.getEditBlackboard()));
            PrimitiveShape.this.getEditGeom().setChanged(true);
        }

        public Point removePoint(int i) {
            PointCoordMap p = (PointCoordMap)PrimitiveShape.this.points.remove(i);
            PrimitiveShape.this.pointsToModel.remove(p.point);
            List<LazyCoord> coords = p.coords;
            for (LazyCoord coord : coords) {
                Iterator iter = PrimitiveShape.this.coordinates.iterator();
                while (iter.hasNext()) {
                    if (iter.next() != coord) continue;
                    iter.remove();
                }
            }
            PrimitiveShape.this.getEditGeom().setChanged(true);
            return p.point;
        }

        public Coordinate removeCoordinate(int i) {
            PrimitiveShape.this.getEditGeom().setChanged(true);
            LazyCoord coord = (LazyCoord)((Object)PrimitiveShape.this.coordinates.remove(i));
            return coord.get(((PointCoordMap)((PrimitiveShape)PrimitiveShape.this).coordsToModel.get((Object)((Object)coord))).point);
        }

        public boolean remove(Point p) {
            List mods = (List)PrimitiveShape.this.pointsToModel.get(p);
            if (mods == null || mods.size() == 0) {
                return false;
            }
            int min = Integer.MAX_VALUE;
            int firstBag = 0;
            int current = 0;
            for (PointCoordMap element : mods) {
                int i = PrimitiveShape.this.points.indexOf(element);
                if (i < min) {
                    min = i;
                    firstBag = current;
                }
                ++current;
            }
            PointCoordMap shapePoint = (PointCoordMap)mods.remove(firstBag);
            PrimitiveShape.this.points.remove(shapePoint);
            PrimitiveShape.this.coordinates.removeAll(shapePoint.coords);
            PrimitiveShape.this.getEditGeom().setChanged(true);
            return true;
        }

        public boolean remove(Coordinate c) {
            PrimitiveShape.this.getEditGeom().setChanged(true);
            return PrimitiveShape.this.coordinates.remove(c);
        }

        public LazyCoord removePoint(int pointIndex, Coordinate coord) {
            PointCoordMap p = (PointCoordMap)PrimitiveShape.this.points.get(pointIndex);
            LazyCoord lcoord = null;
            Iterator<LazyCoord> iter = p.coords.iterator();
            while (iter.hasNext()) {
                LazyCoord lc = iter.next();
                if (!lc.coord.equals((Object)coord)) continue;
                lcoord = lc;
                iter.remove();
                break;
            }
            if (p.coords.isEmpty()) {
                PrimitiveShape.this.points.remove(pointIndex);
                List bags = (List)PrimitiveShape.this.pointsToModel.get(p.point);
                bags.remove(p);
                if (bags.isEmpty()) {
                    PrimitiveShape.this.pointsToModel.remove(p.point);
                }
            }
            if (lcoord == null) {
                return null;
            }
            iter = PrimitiveShape.this.coordinates.iterator();
            while (iter.hasNext()) {
                LazyCoord next = iter.next();
                if (next != lcoord) continue;
                iter.remove();
                PrimitiveShape.this.coordsToModel.remove((Object)next);
            }
            PrimitiveShape.this.getEditGeom().setChanged(true);
            return lcoord;
        }

        public void clear() {
            PrimitiveShape.this.getEditGeom().setChanged(true);
            PrimitiveShape.this.coordinates.clear();
            PrimitiveShape.this.points.clear();
        }

        public boolean hasPoint(Point pointOnLine) {
            return PrimitiveShape.this.pointsToModel.containsKey(pointOnLine);
        }

        @Override
        public ListIterator<Point> iterator() {
            return new ListIterator<Point>(){
                ListIterator<PointCoordMap> iter;
                PointCoordMap current;
                {
                    this.iter = PrimitiveShape.this.points.listIterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public Point next() {
                    this.current = this.iter.next();
                    return this.current.point;
                }

                @Override
                public boolean hasPrevious() {
                    return this.iter.hasPrevious();
                }

                @Override
                public Point previous() {
                    this.current = this.iter.previous();
                    return this.current.point;
                }

                @Override
                public int nextIndex() {
                    return this.iter.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return this.iter.previousIndex();
                }

                @Override
                public void remove() {
                    this.iter.remove();
                }

                @Override
                public void set(Point o) {
                    ArrayList<PointCoordMap> maps = (ArrayList<PointCoordMap>)PrimitiveShape.this.pointsToModel.get(this.current.point);
                    maps.remove(this.current);
                    if (maps.isEmpty()) {
                        PrimitiveShape.this.pointsToModel.remove(this.current.point);
                    }
                    if ((maps = (List)PrimitiveShape.this.pointsToModel.get(o)) == null) {
                        maps = new ArrayList<PointCoordMap>();
                        PrimitiveShape.this.pointsToModel.put(o, maps);
                    }
                    maps.add(this.current);
                    this.current.point = o;
                    PrimitiveShape.this.getEditGeom().setChanged(true);
                }

                @Override
                public void add(Point o) {
                    ArrayList<LazyCoord> list = new ArrayList<LazyCoord>();
                    list.add(new LazyCoord(o, PrimitiveShape.this.getEditBlackboard().toCoord(o), PrimitiveShape.this.getEditBlackboard()));
                    this.iter.add(new PointCoordMap(o, list));
                    PrimitiveShape.this.getEditGeom().setChanged(true);
                }
            };
        }

        public ListIterator<Coordinate> coordIterator() {
            return new ListIterator<Coordinate>(){
                ListIterator<LazyCoord> iter;
                private LazyCoord current;
                {
                    this.iter = PrimitiveShape.this.coordinates.listIterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public Coordinate next() {
                    this.current = this.iter.next();
                    return this.current.get(((PointCoordMap)((PrimitiveShape)((Mutator)Mutator.this).PrimitiveShape.this).coordsToModel.get((Object)((Object)this.current))).point);
                }

                @Override
                public boolean hasPrevious() {
                    return this.iter.hasPrevious();
                }

                @Override
                public Coordinate previous() {
                    this.current = this.iter.previous();
                    return this.current.get(((PointCoordMap)((PrimitiveShape)((Mutator)Mutator.this).PrimitiveShape.this).coordsToModel.get((Object)((Object)this.current))).point);
                }

                @Override
                public int nextIndex() {
                    return this.iter.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return this.iter.previousIndex();
                }

                @Override
                public void remove() {
                    this.iter.remove();
                    PointCoordMap bag = (PointCoordMap)PrimitiveShape.this.coordsToModel.remove((Object)this.current);
                    PrimitiveShape.this.points.remove(bag.point);
                }

                @Override
                public void set(Coordinate o) {
                    this.current.set(o, PrimitiveShape.this.getEditBlackboard().toPoint(o));
                }

                @Override
                public void add(Coordinate o) {
                    Mutator.this.addPoint(this.iter.nextIndex() - 1, PrimitiveShape.this.getEditBlackboard().toPoint(o), Collections.singletonList(o));
                }
            };
        }

        public void reverse() {
            Collections.reverse(PrimitiveShape.this.points);
            Collections.reverse(PrimitiveShape.this.coordinates);
        }

        public List<LazyCoord> getLazyCoordsAt(int i) {
            return ((PointCoordMap)((PrimitiveShape)PrimitiveShape.this).points.get((int)i)).coords;
        }

        Map<? extends Point, ? extends List<Point>> transform(AffineTransform oldToScreen, AffineTransform oldToWorld, PointCoordCalculator pointCoordCalculator) {
            if (Math.abs(pointCoordCalculator.toScreen.getDeterminant() - oldToScreen.getDeterminant()) > 1.0E-6) {
                return this.transformInternal(pointCoordCalculator);
            }
            return this.translate(AffineTransform.getTranslateInstance(pointCoordCalculator.toScreen.getTranslateX() - oldToScreen.getTranslateX(), pointCoordCalculator.toScreen.getTranslateY() - oldToScreen.getTranslateY()), pointCoordCalculator);
        }

        private HashMap<Point, List<Point>> transformInternal(PointCoordCalculator pointCoordCalculator) {
            List oldPoints = PrimitiveShape.this.points;
            HashMap<Point, List<Point>> oldPointToNew = new HashMap<Point, List<Point>>();
            PrimitiveShape.this.points = new ArrayList();
            PrimitiveShape.this.pointsToModel.clear();
            PrimitiveShape.this.coordsToModel.clear();
            EditBlackboard editBlackboard = PrimitiveShape.this.owner.getEditBlackboard();
            for (PointCoordMap map : oldPoints) {
                Point oldPoint = map.point;
                Iterator<LazyCoord> iter = map.coords.iterator();
                while (iter.hasNext()) {
                    LazyCoord c = iter.next();
                    PointCoordMap tmp = map;
                    Coordinate coord = c.get(oldPoint);
                    Point newPoint = pointCoordCalculator.toPoint(coord);
                    if (!newPoint.equals(oldPoint)) {
                        tmp = new PointCoordMap(newPoint);
                        tmp.coords.add(c);
                        iter.remove();
                    }
                    c.pointCoordCalculator = new PointCoordCalculator(pointCoordCalculator);
                    c.start = newPoint;
                    List<Point> pointMapping = oldPointToNew.get(oldPoint);
                    if (pointMapping == null) {
                        pointMapping = new ArrayList<Point>();
                        pointMapping.add(newPoint);
                        oldPointToNew.put(oldPoint, pointMapping);
                    } else {
                        pointMapping.add(newPoint);
                    }
                    tmp.point = newPoint;
                    PrimitiveShape.this.coordsToModel.put(c, tmp);
                    PrimitiveShape.this.points.add(tmp);
                    List list = (List)PrimitiveShape.this.pointsToModel.get(newPoint);
                    if (list == null) {
                        ArrayList<PointCoordMap> l = new ArrayList<PointCoordMap>();
                        l.add(tmp);
                        PrimitiveShape.this.pointsToModel.put(newPoint, l);
                    } else {
                        list.add(tmp);
                    }
                    List<LazyCoord> coords = editBlackboard.coordMapping.get(newPoint);
                    if (coords == null) {
                        ArrayList<LazyCoord> l = new ArrayList<LazyCoord>(tmp.coords);
                        editBlackboard.coordMapping.put(newPoint, l);
                    } else {
                        coords.addAll(tmp.coords);
                    }
                    Set<EditGeom> mappedGeoms = editBlackboard.geomMapping.get(newPoint);
                    if (mappedGeoms == null) {
                        HashSet<EditGeom> l = new HashSet<EditGeom>();
                        l.add(PrimitiveShape.this.getEditGeom());
                        editBlackboard.geomMapping.put(newPoint, l);
                        continue;
                    }
                    if (mappedGeoms.contains(PrimitiveShape.this.getEditGeom())) continue;
                    mappedGeoms.add(PrimitiveShape.this.getEditGeom());
                }
            }
            return oldPointToNew;
        }

        private Map<? extends Point, ? extends List<Point>> translate(AffineTransform oldToNew, PointCoordCalculator pointCoordCalculator) {
            List oldPoints = PrimitiveShape.this.points;
            HashMap<Point, ArrayList<Point>> oldPointToNew = new HashMap<Point, ArrayList<Point>>();
            PrimitiveShape.this.points = new ArrayList();
            PrimitiveShape.this.pointsToModel.clear();
            EditBlackboard editBlackboard = PrimitiveShape.this.owner.getEditBlackboard();
            int diffX = (int)oldToNew.getTranslateX();
            int diffY = (int)oldToNew.getTranslateY();
            for (PointCoordMap map : oldPoints) {
                Point oldPoint = map.point;
                Iterator<LazyCoord> iter = map.coords.iterator();
                while (iter.hasNext()) {
                    LazyCoord c = iter.next();
                    PointCoordMap tmp = map;
                    Point newPoint = Point.valueOf(map.point.getX() + diffX, map.point.getY() + diffY);
                    if (!newPoint.equals(oldPoint)) {
                        tmp = new PointCoordMap(newPoint);
                        tmp.coords.add(c);
                        iter.remove();
                    }
                    c.pointCoordCalculator = new PointCoordCalculator(pointCoordCalculator);
                    c.start = newPoint;
                    ArrayList<Point> pointMapping = (ArrayList<Point>)oldPointToNew.get(oldPoint);
                    if (pointMapping == null) {
                        pointMapping = new ArrayList<Point>();
                        pointMapping.add(newPoint);
                        oldPointToNew.put(oldPoint, pointMapping);
                    } else {
                        pointMapping.add(newPoint);
                    }
                    tmp.point = newPoint;
                    PrimitiveShape.this.coordsToModel.put(c, tmp);
                    PrimitiveShape.this.points.add(tmp);
                    List list = (List)PrimitiveShape.this.pointsToModel.get(newPoint);
                    if (list == null) {
                        ArrayList<PointCoordMap> l = new ArrayList<PointCoordMap>();
                        l.add(tmp);
                        PrimitiveShape.this.pointsToModel.put(newPoint, l);
                    } else {
                        list.add(tmp);
                    }
                    List<LazyCoord> coords = editBlackboard.coordMapping.get(newPoint);
                    if (coords == null) {
                        ArrayList<LazyCoord> l = new ArrayList<LazyCoord>(tmp.coords);
                        editBlackboard.coordMapping.put(newPoint, l);
                    } else {
                        coords.addAll(tmp.coords);
                    }
                    Set<EditGeom> mappedGeoms = editBlackboard.geomMapping.get(newPoint);
                    if (mappedGeoms == null) {
                        HashSet<EditGeom> l = new HashSet<EditGeom>();
                        l.add(PrimitiveShape.this.getEditGeom());
                        editBlackboard.geomMapping.put(newPoint, l);
                        continue;
                    }
                    if (mappedGeoms.contains(PrimitiveShape.this.getEditGeom())) continue;
                    mappedGeoms.add(PrimitiveShape.this.getEditGeom());
                }
            }
            return oldPointToNew;
        }

        public void move(Point start, Point end, LazyCoord coord) {
            PointCoordMap toRemove = null;
            Iterator iterator = ((List)PrimitiveShape.this.pointsToModel.get(start)).iterator();
            if (iterator.hasNext()) {
                PointCoordMap map = (PointCoordMap)iterator.next();
                if (map.coords.contains((Object)coord)) {
                    List startBags = (List)PrimitiveShape.this.pointsToModel.get(start);
                    PointCoordMap endBag = null;
                    int startIndex = PrimitiveShape.this.points.indexOf(map);
                    PointCoordMap before = new PointCoordMap(start);
                    endBag = new PointCoordMap(end);
                    PointCoordMap after = new PointCoordMap(start);
                    PrimitiveShape.this.points.remove(startIndex);
                    int i = 0;
                    for (LazyCoord coord2 : map.coords) {
                        if (i < map.coords.indexOf((Object)coord)) {
                            before.coords.add(coord2);
                            PrimitiveShape.this.coordsToModel.put(coord2, before);
                        } else if (i > map.coords.indexOf((Object)coord)) {
                            after.coords.add(coord2);
                            PrimitiveShape.this.coordsToModel.put(coord2, after);
                        }
                        ++i;
                    }
                    boolean addedBefore = false;
                    boolean addedAfter = false;
                    if (before.coords.size() > 0) {
                        PrimitiveShape.this.points.add(startIndex, before);
                        startBags.add(before);
                        addedBefore = true;
                    }
                    PrimitiveShape.this.points.add(addedBefore ? startIndex + 1 : startIndex, endBag);
                    if (after.coords.size() > 0) {
                        PrimitiveShape.this.points.add(addedBefore ? startIndex + 2 : startIndex + 1, after);
                        startBags.add(after);
                        addedAfter = true;
                    }
                    toRemove = map;
                    ArrayList<PointCoordMap> endBags = (ArrayList<PointCoordMap>)PrimitiveShape.this.pointsToModel.get(end);
                    if (endBags == null) {
                        endBags = new ArrayList<PointCoordMap>();
                        PrimitiveShape.this.pointsToModel.put(end, endBags);
                    }
                    if (!endBags.contains(endBag)) {
                        endBags.add(endBag);
                    }
                    endBag.coords.add(coord);
                    PrimitiveShape.this.coordsToModel.put(coord, endBag);
                    if (addedBefore && !addedAfter || !addedBefore && addedAfter) {
                        this.attemptBeforeAndAfterVertexCollapse(startIndex);
                        this.attemptBeforeAndAfterVertexCollapse(startIndex + 1);
                    } else if (addedBefore && addedAfter) {
                        this.attemptBeforeAndAfterVertexCollapse(startIndex);
                        this.attemptBeforeAndAfterVertexCollapse(startIndex + 2);
                    } else if (!addedBefore && !addedAfter) {
                        this.attemptBeforeAndAfterVertexCollapse(startIndex);
                    }
                }
            }
            if (toRemove != null) {
                ((List)PrimitiveShape.this.pointsToModel.get(start)).remove(toRemove);
            }
        }

        private void attemptBeforeAndAfterVertexCollapse(int index) {
            boolean changed;
            if (PrimitiveShape.this.points.size() == 1 || index > PrimitiveShape.this.points.size() - 1) {
                return;
            }
            int before = index - 1;
            int after = index + 1;
            if (before > -1 && (changed = this.doCollapseVertices(index, before))) {
                index = before;
                --after;
            }
            if (after < PrimitiveShape.this.points.size()) {
                this.doCollapseVertices(after, index);
            }
        }

        private boolean doCollapseVertices(int index, int before) {
            boolean changed = false;
            PointCoordMap currentMap = (PointCoordMap)PrimitiveShape.this.points.get(index);
            PointCoordMap beforeMap = (PointCoordMap)PrimitiveShape.this.points.get(before);
            if (currentMap.point.equals(beforeMap.point)) {
                changed = true;
                PrimitiveShape.this.points.remove(index);
                ((List)PrimitiveShape.this.pointsToModel.get(currentMap.point)).remove(currentMap);
                for (LazyCoord coord : currentMap.coords) {
                    PrimitiveShape.this.coordsToModel.put(coord, beforeMap);
                    beforeMap.coords.add(coord);
                }
            }
            return changed;
        }

        public Iterator<Point> getCopyIterator() {
            return new Iterator<Point>(){
                List<PointCoordMap> newPoints;
                Iterator<PointCoordMap> iter;
                {
                    this.newPoints = new ArrayList<PointCoordMap>(PrimitiveShape.this.points);
                }

                @Override
                public boolean hasNext() {
                    if (this.iter == null) {
                        this.iter = this.newPoints.iterator();
                    }
                    return this.iter.hasNext();
                }

                @Override
                public Point next() {
                    if (this.iter == null) {
                        this.iter = this.newPoints.iterator();
                    }
                    return this.iter.next().point;
                }

                @Override
                public void remove() {
                    throw new IllegalArgumentException("not supported; to inefficient");
                }
            };
        }

        public List<LazyCoord> getLazyCoordsAt(Point point) {
            List bags = (List)PrimitiveShape.this.pointsToModel.get(point);
            ArrayList<LazyCoord> coords = new ArrayList<LazyCoord>();
            if (bags == null) {
                return Collections.emptyList();
            }
            for (PointCoordMap map : bags) {
                coords.addAll(map.coords);
            }
            return coords;
        }

        public void move(int deltaX, int deltaY) {
            HashMap<Point, List> newPointsToModel = new HashMap<Point, List>();
            for (Point point : this) {
                Point dest = Point.valueOf(point.getX() + deltaX, point.getY() + deltaY);
                List oldBags = (List)PrimitiveShape.this.pointsToModel.remove(point);
                if (oldBags == null) continue;
                newPointsToModel.put(dest, oldBags);
                for (PointCoordMap map : oldBags) {
                    map.point = dest;
                }
            }
            for (Map.Entry entry : newPointsToModel.entrySet()) {
                List newBags = (List)PrimitiveShape.this.pointsToModel.get(entry.getKey());
                if (newBags == null) {
                    PrimitiveShape.this.pointsToModel.put((Point)entry.getKey(), (List)entry.getValue());
                    continue;
                }
                newBags.addAll((Collection)entry.getValue());
            }
            PrimitiveShape.this.pointsToModel = newPointsToModel;
        }
    }

    private static class PointCoordMap {
        Point point;
        final List<LazyCoord> coords;

        public PointCoordMap(Point p, List<LazyCoord> coords) {
            this.point = p;
            this.coords = coords;
        }

        public PointCoordMap(Point p) {
            this.point = p;
            this.coords = new ArrayList<LazyCoord>();
        }

        public String toString() {
            return "{" + this.point + "=" + this.coords + "}";
        }
    }
}

