/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.support;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.geom.AffineTransform;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.support.Point;
import org.opengis.referencing.operation.MathTransform;

public class PointCoordCalculator {
    final AffineTransform toScreen;
    final AffineTransform toWorld;
    MathTransform layerToMap;
    MathTransform mapToLayer;

    public PointCoordCalculator(AffineTransform toScreen, MathTransform layerToMap) {
        AffineTransform temp;
        this.toScreen = new AffineTransform(toScreen);
        this.layerToMap = layerToMap;
        try {
            temp = this.toScreen.createInverse();
        }
        catch (Exception exception) {
            temp = toScreen;
        }
        this.toWorld = temp;
        try {
            this.mapToLayer = this.layerToMap.inverse();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public PointCoordCalculator(PointCoordCalculator other) {
        this.toScreen = new AffineTransform(other.toScreen);
        this.toWorld = new AffineTransform(other.toWorld);
        this.layerToMap = other.layerToMap;
        this.mapToLayer = other.mapToLayer;
    }

    public synchronized Coordinate toCoord(Point point) {
        double x = (double)point.getX() + 0.5;
        double y = (double)point.getY() + 0.5;
        double[] src = new double[]{x, y};
        double[] dest = new double[2];
        this.toWorld.transform(src, 0, src, 0, 1);
        if (this.mapToLayer.isIdentity()) {
            dest = src;
        } else {
            try {
                this.mapToLayer.transform(src, 0, dest, 0, 1);
            }
            catch (Exception e) {
                EditPlugin.log("", e);
            }
        }
        return new Coordinate(dest[0], dest[1]);
    }

    public synchronized Point toPoint(Coordinate coord) {
        double[] src = new double[]{coord.x, coord.y};
        double[] dest = new double[2];
        if (this.layerToMap.isIdentity()) {
            dest = src;
        } else {
            try {
                this.layerToMap.transform(src, 0, dest, 0, 1);
            }
            catch (Exception e) {
                EditPlugin.log("", e);
            }
        }
        this.toScreen.transform(dest, 0, dest, 0, 1);
        return Point.valueOf((int)dest[0], (int)dest[1]);
    }

    public void setMapToLayer(MathTransform mapToLayer2) {
        this.mapToLayer = mapToLayer2;
        try {
            this.layerToMap = this.mapToLayer.inverse();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

