/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.support;

import java.awt.geom.PathIterator;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.PathData;

public class PathToPathIteratorAdapter
implements PathIterator {
    private PathData data;
    private int pointIndex = 0;
    private int typeIndex = 0;

    public PathToPathIteratorAdapter(Path path) {
        this.data = path.getPathData();
    }

    @Override
    public int currentSegment(float[] coords) {
        int num = this.getNumPoints();
        System.arraycopy(this.data.points, this.pointIndex, coords, 0, num);
        return this.getSegType();
    }

    private int getSegType() {
        switch (this.data.types[this.typeIndex]) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
        }
        throw new IllegalArgumentException(String.valueOf(this.data.types[this.typeIndex]) + " is an unknown value");
    }

    @Override
    public int currentSegment(double[] coords) {
        int num = this.getNumPoints();
        int i = 0;
        while (i < num) {
            coords[i] = this.data.points[i + this.pointIndex];
            ++i;
        }
        return this.getSegType();
    }

    @Override
    public int getWindingRule() {
        return 0;
    }

    @Override
    public boolean isDone() {
        return this.typeIndex == this.data.types.length;
    }

    @Override
    public void next() {
        this.pointIndex += this.getNumPoints();
        ++this.typeIndex;
    }

    private int getNumPoints() {
        switch (this.data.types[this.typeIndex]) {
            case 1: {
                return 2;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 6;
            }
            case 5: {
                return 0;
            }
        }
        throw new IllegalArgumentException(String.valueOf(this.data.types[this.typeIndex]) + " is an unknown value");
    }
}

