/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.support;

import com.vividsolutions.jts.geom.Coordinate;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PointCoordCalculator;

public class LazyCoord
extends Coordinate {
    private static final long serialVersionUID = 8814031966871200006L;
    Point start;
    private EditBlackboard blackboard;
    Coordinate coord;
    PointCoordCalculator pointCoordCalculator;
    private double differenceX;
    private double differenceY;
    private final Object obj = new Object();

    public LazyCoord(Point point2, Coordinate coord2, EditBlackboard bb2) {
        this.start = point2;
        this.pointCoordCalculator = new PointCoordCalculator(bb2.pointCoordCalculator);
        this.blackboard = bb2;
        this.coord = coord2;
        Coordinate calculated = this.pointCoordCalculator.toCoord(this.start);
        this.differenceX = calculated.x - this.coord.x;
        this.differenceY = calculated.y - this.coord.y;
        this.x = this.coord.x;
        this.y = this.coord.y;
        this.z = this.coord.z;
    }

    public LazyCoord(LazyCoord coord2) {
        this(coord2.start, coord2.coord, coord2.blackboard);
    }

    public Coordinate get(Point p) {
        boolean sameTransform = this.pointCoordCalculator.toScreen.equals(this.blackboard.pointCoordCalculator.toScreen);
        if (p.equals(this.start) && sameTransform) {
            this.x = this.coord.x;
            this.y = this.coord.y;
            this.z = this.coord.z;
            return new Coordinate((Coordinate)this);
        }
        double[] startEndDelta = new double[2];
        Coordinate endTransform = this.blackboard.pointCoordCalculator.toCoord(p);
        startEndDelta[0] = endTransform.x - this.coord.x;
        startEndDelta[1] = endTransform.y - this.coord.y;
        this.coord.x = this.coord.x + startEndDelta[0] - this.differenceX;
        this.coord.y = this.coord.y + startEndDelta[1] - this.differenceY;
        this.x = this.coord.x;
        this.y = this.coord.y;
        this.pointCoordCalculator = new PointCoordCalculator(this.blackboard.pointCoordCalculator);
        this.start = p;
        return new Coordinate((Coordinate)this);
    }

    public void set(Coordinate o, Point point) {
        this.coord = o;
        this.x = o.x;
        this.y = o.y;
        this.z = o.z;
        this.start = point;
    }

    public String toString() {
        return this.start.toString();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return this.obj.hashCode();
    }
}

