/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.support;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.RobustCGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.core.internal.GeometryBuilder;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import net.refractions.udig.tools.edit.support.ShapeType;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.opengis.feature.type.GeometryDescriptor;

public class GeometryCreationUtil {
    public static final RobustCGAlgorithms cga = new RobustCGAlgorithms();

    public static Map<String, Bag> createAllGeoms(EditGeom currentGeom, Class geomToCreate, GeometryDescriptor geomAttribute, boolean showErrors) {
        EditBlackboard blackboard = currentGeom.getEditBlackboard();
        List<EditGeom> editGeoms = blackboard.getGeoms();
        HashMap<String, Bag> idToGeom = new HashMap<String, Bag>();
        for (EditGeom editGeom : editGeoms) {
            if (!editGeom.isChanged() || idToGeom.containsKey(editGeom.getFeatureIDRef().get())) continue;
            idToGeom.put(editGeom.getFeatureIDRef().get(), new Bag(editGeom));
        }
        for (EditGeom editGeom : editGeoms) {
            if (!idToGeom.containsKey(editGeom.getFeatureIDRef().get()) || !idToGeom.containsKey(editGeom.getFeatureIDRef().get()) || editGeom.getShell().getNumPoints() <= 0) continue;
            Bag bag = (Bag)idToGeom.get(editGeom.getFeatureIDRef().get());
            Class geometryType = GeometryCreationUtil.determineGeometryType(currentGeom, editGeom, geomToCreate, geomAttribute);
            Object createGeom = GeometryCreationUtil.createGeom(geometryType, editGeom.getShell(), showErrors);
            bag.jts.add((Geometry)createGeom);
        }
        return idToGeom;
    }

    public static Class determineGeometryType(EditGeom currentGeom, EditGeom editGeom, Class geomToCreate, GeometryDescriptor geomAttribute) {
        if (editGeom.getFeatureIDRef().get() == null && currentGeom.getFeatureIDRef().get() == null || editGeom.getFeatureIDRef().get().equals(currentGeom.getFeatureIDRef().get())) {
            return geomToCreate;
        }
        ShapeType attributeDefinedType = ShapeType.valueOf(geomAttribute.getType().getBinding());
        ShapeType typeToSwitchOn = attributeDefinedType != editGeom.getShapeType() && attributeDefinedType != ShapeType.UNKNOWN || editGeom.getShapeType() == ShapeType.UNKNOWN ? attributeDefinedType : editGeom.getShapeType();
        switch (typeToSwitchOn) {
            case LINE: {
                return LineString.class;
            }
            case POINT: {
                return Point.class;
            }
            case POLYGON: {
                return Polygon.class;
            }
            case UNKNOWN: {
                if (geomAttribute.getType().getBinding() != Geometry.class && geomAttribute.getType().getBinding() != GeometryCollection.class) break;
                PrimitiveShape shell = editGeom.getShell();
                if (shell.getNumPoints() == 1) {
                    return Point.class;
                }
                if (shell.getPoint(0).equals(shell.getPoint(shell.getNumPoints() - 1)) && shell.getNumCoords() != 2) {
                    return Polygon.class;
                }
                return LineString.class;
            }
        }
        return null;
    }

    public static <T extends Geometry> T createGeom(Class<T> geomToCreate, PrimitiveShape shape, boolean showError) {
        Object geom = geomToCreate == Polygon.class ? GeometryCreationUtil.createPolygon(shape.getEditGeom()) : (geomToCreate == LinearRing.class ? GeometryBuilder.create().safeCreateGeometry(LinearRing.class, shape.coordArray()) : (geomToCreate == LineString.class ? GeometryBuilder.create().safeCreateGeometry(LineString.class, shape.coordArray()) : GeometryBuilder.create().safeCreateGeometry(Point.class, shape.coordArray())));
        if (!geom.isValid()) {
            final Display display = Display.getDefault();
            if (showError) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Status errorStatus = new Status(4, "net.refractions.udig.tools.edit", 4, Messages.GeometryCreationUtil_errorMsg, null);
                        ErrorDialog.openError((Shell)display.getActiveShell(), (String)Messages.GeometryCreationUtil_errorTitle, (String)Messages.GeometryCreationUtil_errorMsg, (IStatus)errorStatus);
                    }
                });
                throw new IllegalStateException("Geometry constructed from EditGeom: " + shape.getEditGeom().getFeatureIDRef().get() + " resulted in an invalid geometry");
            }
        }
        return (T)((Geometry)geomToCreate.cast(geom));
    }

    public static Polygon createPolygon(EditGeom currentGeom) {
        Coordinate[] shellCoords = currentGeom.getShell().coordArray();
        LinearRing shell = GeometryBuilder.create().safeCreateLinearRing(shellCoords);
        try {
            if (CGAlgorithms.isCCW((Coordinate[])shellCoords)) {
                shell = JTSUtilities.reverseRing((LinearRing)shell);
            }
        }
        catch (Exception e) {
            EditPlugin.log("Not a critical problem, just an FYI", e);
        }
        ArrayList<LinearRing> currentHoles = new ArrayList<LinearRing>();
        for (PrimitiveShape shape : currentGeom.getHoles()) {
            Coordinate[] coordArray = shape.coordArray();
            if (coordArray.length == 0) continue;
            LinearRing hole = GeometryBuilder.create().safeCreateLinearRing(coordArray);
            if (coordArray.length > 2 && !CGAlgorithms.isCCW((Coordinate[])coordArray)) {
                hole = JTSUtilities.reverseRing((LinearRing)hole);
            }
            currentHoles.add(hole);
        }
        GeometryFactory factory = new GeometryFactory();
        LinearRing[] holes = currentHoles.toArray(new LinearRing[currentHoles.size()]);
        return factory.createPolygon(shell, holes);
    }

    public static Geometry ceateGeometryCollection(List<Geometry> geoms, Class<Geometry> schemaDeclaredType) {
        if (geoms.isEmpty()) {
            return null;
        }
        if (schemaDeclaredType.isAssignableFrom(geoms.get(0).getClass()) && geoms.size() == 1) {
            return geoms.get(0);
        }
        if (!GeometryCollection.class.isAssignableFrom(schemaDeclaredType) && !schemaDeclaredType.isAssignableFrom(GeometryCollection.class)) {
            return geoms.get(0);
        }
        GeometryFactory factory = new GeometryFactory();
        Class<?> geomType = geoms.get(0).getClass();
        Object geom = geomType == Polygon.class ? factory.createMultiPolygon(geoms.toArray(new Polygon[geoms.size()])) : (geomType == LinearRing.class ? factory.createMultiLineString(geoms.toArray(new LineString[geoms.size()])) : (geomType == LineString.class ? factory.createMultiLineString(geoms.toArray(new LineString[geoms.size()])) : factory.createMultiPoint(geoms.toArray(new Point[geoms.size()]))));
        return geom;
    }

    public static class Bag {
        public EditGeom geom;
        public List<Geometry> jts = new ArrayList<Geometry>();

        public Bag(EditGeom geom) {
            this.geom = geom;
        }
    }
}

