/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.support;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LinearRing;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.refractions.udig.core.IBlockingProvider;
import net.refractions.udig.core.IProvider;
import net.refractions.udig.core.internal.FeatureUtils;
import net.refractions.udig.mapgraphic.grid.GridMapGraphic;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.Interaction;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.ui.AnimationUpdater;
import net.refractions.udig.project.ui.IAnimation;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import net.refractions.udig.project.ui.tool.IToolContext;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.animation.SearchBoxAnimation;
import net.refractions.udig.tools.edit.commands.AddVertexCommand;
import net.refractions.udig.tools.edit.commands.CreateAndSelectHoleCommand;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.ClosestEdge;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.EditGeomPathIterator;
import net.refractions.udig.tools.edit.support.IsBusyStateProvider;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import net.refractions.udig.tools.edit.support.PrimitiveShapeIterator;
import net.refractions.udig.tools.edit.support.ShapeType;
import net.refractions.udig.tools.edit.support.SnapBehaviour;
import net.refractions.udig.ui.ProgressManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.data.FeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.identity.Identifier;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class EditUtils {
    static final int TOP = 8;
    static final int BOTTOM = 4;
    static final int RIGHT = 2;
    static final int LEFT = 1;
    public static final int OVER_EDGE = -1;
    public static final int NO_INTERSECTION = -2;
    private static final String EDIT_FEATURE_BOUNDS = "BOUNDS OF RENDERING FILTER";
    public static EditUtils instance = new EditUtils();
    private static /* synthetic */ int[] $SWITCH_TABLE$net$refractions$udig$tools$edit$support$SnapBehaviour;

    public int overVertext(Coordinate[] coords, Envelope env) {
        if (coords == null) {
            return -2;
        }
        int i = 0;
        while (i < coords.length) {
            Coordinate coord = coords[i];
            if (env.contains(coord)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean overEdgeCoordinatePrecision(PrimitiveShape shape, Envelope env) {
        if (shape.getNumCoords() < 2) {
            return false;
        }
        Coordinate endPoint1 = shape.getCoord(shape.getNumCoords() - 1);
        int i = 0;
        while (i < shape.getNumCoords()) {
            Coordinate endPoint2 = shape.getCoord(i);
            if (this.overEdge(endPoint1, endPoint2, env)) {
                return true;
            }
            endPoint1 = endPoint2;
            ++i;
        }
        return false;
    }

    public boolean overEdgePixelPrecision(PrimitiveShape shape, Envelope env) {
        if (shape.getNumPoints() < 2) {
            return false;
        }
        Point point1 = shape.getPoint(shape.getNumPoints() - 1);
        int i = 0;
        while (i < shape.getNumPoints()) {
            Coordinate endPoint2;
            Point point2 = shape.getPoint(i);
            Coordinate endPoint1 = new Coordinate((double)point1.getX(), (double)point1.getY());
            if (this.overEdge(endPoint1, endPoint2 = new Coordinate((double)point2.getX(), (double)point2.getY()), env)) {
                return true;
            }
            point1 = point2;
            ++i;
        }
        return false;
    }

    public boolean overEdge(Coordinate endPoint1, Coordinate endPoint2, Envelope env) {
        boolean accept = false;
        boolean done = false;
        double x0 = endPoint1.x;
        double y0 = endPoint1.y;
        double x1 = endPoint2.x;
        double y1 = endPoint2.y;
        double xmin = env.getMinX();
        double ymin = env.getMinY();
        double xmax = env.getMaxX();
        double ymax = env.getMaxY();
        int outcode0 = this.compOutCode(x0, y0, xmin, xmax, ymin, ymax);
        int outcode1 = this.compOutCode(x1, y1, xmin, xmax, ymin, ymax);
        do {
            double tmpy;
            double tmpx;
            double y;
            double x;
            int outcodeOut;
            if (outcode0 == 0 || outcode1 == 0) {
                done = true;
                accept = true;
                continue;
            }
            if ((outcode0 & outcode1) != 0) {
                done = true;
                continue;
            }
            int n = outcodeOut = outcode0 > 0 ? outcode0 : outcode1;
            if ((outcodeOut & 8) > 0) {
                x = x0 + (x1 - x0) * (ymax - y0) / (y1 - y0);
                y = ymax;
            } else if ((outcodeOut & 4) > 0) {
                x = x0 + (x1 - x0) * (ymin - y0) / (y1 - y0);
                y = ymin;
            } else if ((outcodeOut & 2) > 0) {
                y = y0 + (y1 - y0) * (xmax - x0) / (x1 - x0);
                x = xmax;
            } else {
                y = y0 + (y1 - y0) * (xmin - x0) / (x1 - x0);
                x = xmin;
            }
            if (outcodeOut == outcode0) {
                tmpx = x;
                tmpy = y;
                outcode0 = this.compOutCode(tmpx, tmpy, xmin, xmax, ymin, ymax);
                continue;
            }
            tmpx = x;
            tmpy = y;
            outcode1 = this.compOutCode(tmpx, tmpy, xmin, xmax, ymin, ymax);
        } while (!done);
        return accept;
    }

    private int compOutCode(double x, double y, double xmin, double xmax, double ymin, double ymax) {
        int outcode = 0;
        if (y > ymax) {
            outcode |= 8;
        }
        if (y < ymin) {
            outcode |= 4;
        }
        if (x > xmax) {
            outcode |= 2;
        }
        if (x < xmin) {
            outcode |= 1;
        }
        return outcode;
    }

    public int getClosest(Geometry geometry, Coordinate click, Coordinate[] result) {
        Coordinate[] coordinates = geometry.getCoordinates();
        int prev = 0;
        double mindist = Double.MAX_VALUE;
        Coordinate closest = coordinates[coordinates.length - 1];
        double x = click.x - closest.x;
        double y = click.y - closest.y;
        mindist = Math.sqrt(x * x + y * y);
        int i = 0;
        while (i < coordinates.length) {
            Coordinate point = coordinates[i];
            x = click.x - point.x;
            y = click.y - point.y;
            double dist = Math.sqrt(x * x + y * y);
            if (dist < mindist) {
                mindist = dist;
                prev = i;
                closest = point;
            }
            ++i;
        }
        result[0] = closest;
        if (geometry instanceof LinearRing) {
            return prev == 0 || prev == coordinates.length ? coordinates.length - 2 : prev;
        }
        return prev != 0 ? prev - 1 : coordinates.length - 2;
    }

    public Coordinate closestCoordinateOnEdge(Coordinate endPoint1, Coordinate endPoint2, Coordinate src) {
        Coordinate v = new Coordinate();
        v.x = endPoint2.x - endPoint1.x;
        v.y = endPoint2.y - endPoint1.y;
        double d = v.x * v.x + v.y * v.y;
        if (d == 0.0) {
            return null;
        }
        double t = ((src.x - endPoint1.x) * v.x + (src.y - endPoint1.y) * v.y) / d;
        if (t < 0.0 || t > 1.0 || Double.isInfinite(t) || Double.isNaN(t)) {
            return null;
        }
        Coordinate result = new Coordinate();
        result.x = endPoint1.x + t * v.x;
        result.y = endPoint1.y + t * v.y;
        return result;
    }

    public Point closestPointOnEdge(Point endPoint1, Point endPoint2, Point src) {
        int k;
        if (endPoint1.equals(src)) {
            return src;
        }
        if (endPoint2.equals(src)) {
            return src;
        }
        Point v = Point.valueOf(endPoint2.getX() - endPoint1.getX(), endPoint2.getY() - endPoint1.getY());
        int i = v.getX() * v.getX() + v.getY() * v.getY();
        if (i == 0) {
            return null;
        }
        int j = (src.getX() - endPoint1.getX()) * v.getX();
        double t = (double)(j + (k = (src.getY() - endPoint1.getY()) * v.getY())) / (double)i;
        if (t >= 1.0) {
            return endPoint2;
        }
        if (t <= 0.0) {
            return endPoint1;
        }
        if (Double.isInfinite(t) || Double.isNaN(t)) {
            return null;
        }
        return Point.valueOf((int)((double)endPoint1.getX() + t * (double)v.getX()), (int)((double)endPoint1.getY() + t * (double)v.getY()));
    }

    public Coordinate getTransformedClick(Coordinate click, ILayer layer) {
        try {
            MathTransform transform = layer.mapToLayerTransform();
            if (transform == null || transform.isIdentity()) {
                return click;
            }
            return JTS.transform((Coordinate)click, (Coordinate)new Coordinate(), (MathTransform)transform);
        }
        catch (Exception exception) {
            return click;
        }
    }

    public List<EditGeom> getIntersectingGeom(EditBlackboard editBlackboard, Point point, boolean treatUnknownAsPolygons) {
        List<EditGeom> geoms = editBlackboard.getGeoms();
        LinkedList<EditGeom> result = new LinkedList<EditGeom>();
        for (EditGeom geom : geoms) {
            EditGeomPathIterator iter = EditGeomPathIterator.getPathIterator(geom);
            iter.setPolygon(treatUnknownAsPolygons);
            if (!iter.toShape().contains(point.getX(), point.getY())) continue;
            result.add(geom);
        }
        return result;
    }

    public Coordinate snapToGrid(Point centerPoint, IMap map) {
        double[] closest;
        List layers = map.getMapLayers();
        ILayer found = (ILayer)layers.get(0);
        GridMapGraphic graphic = new GridMapGraphic();
        for (ILayer layer : layers) {
            if (!layer.hasResource(GridMapGraphic.class)) continue;
            found = layer;
            try {
                graphic = (GridMapGraphic)layer.getResource(GridMapGraphic.class, ProgressManager.instance().get(new Object[0]));
                break;
            }
            catch (IOException e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
        }
        try {
            closest = graphic.closest(centerPoint.getX(), centerPoint.getY(), found);
        }
        catch (FactoryException e) {
            EditPlugin.log(null, e);
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        return new Coordinate(closest[0], closest[1], 0.0);
    }

    /*
     * Unable to fully structure code
     */
    public Coordinate getClosestSnapPoint(EditToolHandler handler, EditBlackboard editBlackboard, Point centerPoint, boolean includeVerticesInCurrent, SnapBehaviour snapBehaviour, EditState stateAfterSearch) {
        context = handler.getContext();
        minFinder = new MinFinder(editBlackboard.toCoord(centerPoint));
        anim = new SearchBoxAnimation(centerPoint, (IProvider<Boolean>)new IsBusyStateProvider(handler));
        try {
            block24: {
                handler.setCurrentState(EditState.BUSY);
                if (snapBehaviour != SnapBehaviour.OFF && snapBehaviour != SnapBehaviour.GRID) {
                    AnimationUpdater.runTimer((IMapDisplay)context.getMapDisplay(), (IAnimation)anim);
                }
                switch (EditUtils.$SWITCH_TABLE$net$refractions$udig$tools$edit$support$SnapBehaviour()[snapBehaviour.ordinal()]) {
                    case 1: {
                        return null;
                    }
                    case 2: {
                        this.searchSelection(handler, editBlackboard, centerPoint, includeVerticesInCurrent, minFinder);
                        var13_10 = minFinder.getMinCoord();
                        return var13_10;
                    }
                    case 3: {
                        this.searchSelection(handler, editBlackboard, centerPoint, includeVerticesInCurrent, minFinder);
                        minFinder.add(this.searchLayer(handler.getEditLayer(), context, centerPoint));
                        break;
                    }
                    case 4: {
                        this.searchSelection(handler, editBlackboard, centerPoint, includeVerticesInCurrent, minFinder);
                        for (ILayer layer : context.getMapLayers()) {
                            minFinder.add(this.searchLayer(layer, context, centerPoint));
                        }
                        break;
                    }
                    case 5: {
                        worldCoord = this.snapToGrid(centerPoint, context.getMap());
                        try {
                            var13_11 = JTS.transform((Coordinate)worldCoord, null, (MathTransform)editBlackboard.pointCoordCalculator.mapToLayer);
                            return var13_11;
                        }
                        catch (TransformException v0) {
                            if (stateAfterSearch != EditState.BUSY) ** GOTO lbl35
                            handler.setCurrentState(EditState.MODIFYING);
                            ** GOTO lbl36
lbl35:
                            // 1 sources

                            handler.setCurrentState(stateAfterSearch);
lbl36:
                            // 2 sources

                            anim.setValid(false);
                            return null;
                        }
                    }
                }
                min = minFinder.getMinCoord();
                try {
                    if (min != null) break block24;
                    return null;
                }
                catch (Exception e) {
                    EditPlugin.log("", e);
                    return null;
                }
            }
            var13_12 = JTS.transform((Coordinate)min, (Coordinate)new Coordinate(), (MathTransform)editBlackboard.pointCoordCalculator.mapToLayer);
            return var13_12;
            {
                catch (Throwable var12_17) {
                    throw var12_17;
                }
            }
        }
        finally {
            if (stateAfterSearch == EditState.BUSY) {
                handler.setCurrentState(EditState.MODIFYING);
            } else {
                handler.setCurrentState(stateAfterSearch);
            }
            anim.setValid(false);
        }
    }

    private void searchSelection(EditToolHandler handler, EditBlackboard editBlackboard, Point centerPoint, boolean includeVerticesInCurrent, MinFinder minFinder) {
        Point point = editBlackboard.overVertex(centerPoint, PreferenceUtil.instance().getSnappingRadius(), true);
        boolean containsNonCurrentShape = this.containsNonCurrentShape(point, editBlackboard, handler.getCurrentShape());
        if (point != null && (includeVerticesInCurrent || containsNonCurrentShape)) {
            minFinder.add(editBlackboard.toCoord(point));
        }
    }

    private boolean containsNonCurrentShape(Point p, EditBlackboard editBlackboard, PrimitiveShape currentShape) {
        if (p == null || currentShape == null) {
            return false;
        }
        List<EditGeom> geoms = editBlackboard.getGeoms(p.getX(), p.getY());
        if (geoms.isEmpty()) {
            return false;
        }
        return geoms.size() > 1 || geoms.get(0) != currentShape.getEditGeom();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Coordinate searchLayer(ILayer layer, IToolContext context, Point centerPoint) {
        if (!layer.hasResource(FeatureSource.class)) return null;
        if (!layer.getInteraction(Interaction.EDIT)) return null;
        if (!layer.isVisible()) {
            return null;
        }
        ILayer editLayer = context.getEditManager().getEditLayer();
        SimpleFeature editFeature = context.getEditManager().getEditFeature();
        String editFeatureID = null;
        if (editFeature != null) {
            editFeatureID = editFeature.getID();
        }
        ReferencedEnvelope bbox = context.getBoundingBox(new java.awt.Point(centerPoint.getX(), centerPoint.getY()), PreferenceUtil.instance().getSnappingRadius() * 2);
        try {
            Coordinate tmp = context.pixelToWorld(centerPoint.getX(), centerPoint.getY());
            Coordinate layerCenter = JTS.transform((Coordinate)tmp, (Coordinate)new Coordinate(), (MathTransform)layer.mapToLayerTransform());
            FeatureCollection features = context.getFeaturesInBbox(layer, (Envelope)bbox);
            FeatureIterator iter = null;
            try {
                Coordinate closest = null;
                double minDist = 2.147483647E9;
                iter = features.features();
                while (true) {
                    double distNew;
                    double y;
                    double x;
                    if (!iter.hasNext()) {
                        if (closest == null) return null;
                        Coordinate inMapCoords = new Coordinate();
                        JTS.transform(closest, (Coordinate)inMapCoords, (MathTransform)layer.layerToMapTransform());
                        java.awt.Point point = context.worldToPixel(inMapCoords);
                        x = centerPoint.getX() - point.x;
                        y = centerPoint.getY() - point.y;
                        distNew = Math.sqrt(x * x + y * y);
                        if (!(distNew < (double)PreferenceUtil.instance().getSnappingRadius())) return null;
                        Coordinate coordinate = inMapCoords;
                        return coordinate;
                    }
                    SimpleFeature feature = (SimpleFeature)iter.next();
                    if (feature.getID().equals(editFeatureID) && layer == editLayer) continue;
                    Coordinate[] result = new Coordinate[1];
                    instance.getClosest((Geometry)feature.getDefaultGeometry(), layerCenter, result);
                    x = layerCenter.x - result[0].x;
                    y = layerCenter.y - result[0].y;
                    distNew = Math.sqrt(x * x + y * y);
                    if (!(distNew < minDist)) continue;
                    closest = result[0];
                    minDist = distNew;
                }
            }
            finally {
                if (iter != null) {
                    features.close(iter);
                }
            }
        }
        catch (Exception e) {
            EditPlugin.log("", e);
        }
        return null;
    }

    public Coordinate intersectingLines(Coordinate line1P1, Coordinate line1P2, Coordinate line2P1, Coordinate line2P2) {
        boolean onLine2;
        double B1 = line1P1.x - line1P2.x;
        double B2 = line2P1.x - line2P2.x;
        double A1 = line1P2.y - line1P1.y;
        double A2 = line2P2.y - line2P1.y;
        double C1 = A1 * line1P1.x + B1 * line1P1.y;
        double C2 = A2 * line2P1.x + B2 * line2P1.y;
        double det = A1 * B2 - A2 * B1;
        if (det == 0.0) {
            return null;
        }
        double x = (B2 * C1 - B1 * C2) / det;
        double y = (A1 * C2 - A2 * C1) / det;
        boolean onLine1 = Math.min(line1P1.x, line1P2.x) <= x && x <= Math.max(line1P1.x, line1P2.x) && Math.min(line1P1.y, line1P2.y) <= y && y <= Math.max(line1P1.y, line1P2.y);
        boolean bl = onLine2 = Math.min(line2P1.x, line2P2.x) <= x && x <= Math.max(line2P1.x, line2P2.x) && Math.min(line2P1.y, line2P2.y) <= y && y <= Math.max(line2P1.y, line2P2.y);
        if (onLine1 && onLine2) {
            return new Coordinate(x, y);
        }
        return null;
    }

    public Point intersectingLines(Point line1P1, Point line1P2, Point line2P1, Point line2P2) {
        boolean onLine2;
        int B1 = line1P1.getX() - line1P2.getX();
        int B2 = line2P1.getX() - line2P2.getX();
        int A1 = line1P2.getY() - line1P1.getY();
        int A2 = line2P2.getY() - line2P1.getY();
        int C1 = A1 * line1P1.getX() + B1 * line1P1.getY();
        int C2 = A2 * line2P1.getX() + B2 * line2P1.getY();
        double det = A1 * B2 - A2 * B1;
        if (det == 0.0) {
            return null;
        }
        double x = (double)(B2 * C1 - B1 * C2) / det;
        double y = (double)(A1 * C2 - A2 * C1) / det;
        boolean onLine1 = (double)Math.min(line1P1.getX(), line1P2.getX()) <= x && x <= (double)Math.max(line1P1.getX(), line1P2.getX()) && (double)Math.min(line1P1.getY(), line1P2.getY()) <= y && y <= (double)Math.max(line1P1.getY(), line1P2.getY());
        boolean bl = onLine2 = (double)Math.min(line2P1.getX(), line2P2.getX()) <= x && x <= (double)Math.max(line2P1.getX(), line2P2.getX()) && (double)Math.min(line2P1.getY(), line2P2.getY()) <= y && y <= (double)Math.max(line2P1.getY(), line2P2.getY());
        if (onLine1 && onLine2) {
            return Point.valueOf((int)x, (int)y);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reverseOrder(PrimitiveShape shape) {
        EditBlackboard editBlackboard = shape.getEditBlackboard();
        synchronized (editBlackboard) {
            shape.getMutator().reverse();
        }
    }

    public UndoableComposite appendPathToShape(EditToolHandler handler, PathIterator iter, PrimitiveShape shape) {
        EditBlackboard bb = shape.getEditBlackboard();
        StaticShapeProvider currentProvider = new StaticShapeProvider(shape);
        return this.appendPathToShape(iter, shape.getEditGeom().getShapeType(), handler, bb, currentProvider);
    }

    public UndoableComposite appendPathToShape(PathIterator iter, ShapeType shapeType, EditToolHandler handler, EditBlackboard bb, IBlockingProvider<PrimitiveShape> currentProvider2) {
        IBlockingProvider<PrimitiveShape> currentProvider = currentProvider2;
        ArrayList<AbstractCommand> commands = new ArrayList<AbstractCommand>();
        commands.add(new StartBatchingCommand(bb));
        float[] coords = new float[6];
        boolean started = false;
        float[] start = new float[2];
        AddVertexCommand addVertexCommand = null;
        while (!iter.isDone()) {
            int type = iter.currentSegment(coords);
            switch (type) {
                case 0: {
                    if (!started) {
                        started = true;
                    } else {
                        if (shapeType != ShapeType.POLYGON) {
                            throw new IllegalArgumentException("Holes can not to shapes that are not Polygons.  Current shape is a " + (Object)((Object)shapeType));
                        }
                        CreateAndSelectHoleCommand command = new CreateAndSelectHoleCommand(currentProvider);
                        currentProvider = command.getHoleProvider();
                        commands.add(command);
                    }
                    start[0] = coords[0];
                    start[1] = coords[1];
                }
                case 1: {
                    addVertexCommand = new AddVertexCommand(handler, bb, currentProvider, Point.valueOf((int)coords[0], (int)coords[1]), false);
                    addVertexCommand.setShowAnimation(false);
                    commands.add(addVertexCommand);
                    break;
                }
                case 4: {
                    if (Point.valueOf((int)coords[0], (int)coords[1]).equals(Point.valueOf((int)start[0], (int)start[1]))) break;
                    addVertexCommand = new AddVertexCommand(handler, bb, currentProvider, Point.valueOf((int)start[0], (int)start[1]), false);
                    addVertexCommand.setShowAnimation(false);
                    commands.add(addVertexCommand);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("not supported");
                }
            }
            iter.next();
        }
        if (shapeType == ShapeType.POLYGON && addVertexCommand != null && !addVertexCommand.getPointToAdd().equals(Point.valueOf((int)start[0], (int)start[1]))) {
            commands.add(new AddVertexCommand(handler, bb, currentProvider, Point.valueOf((int)start[0], (int)start[1]), false));
        }
        UndoableComposite undoableComposite = new UndoableComposite(commands);
        undoableComposite.getFinalizerCommands().add(new FireEventsCommand(bb));
        return undoableComposite;
    }

    public static Coordinate midPointOnLine(Coordinate coord, Coordinate coord2) {
        double x = (coord.x + coord2.x) / 2.0;
        double y = (coord.y + coord2.y) / 2.0;
        return new Coordinate(x, y);
    }

    public void clearLayerStateShapeCache(Collection<ILayer> layers) {
        for (ILayer layer : layers) {
            layer.getBlackboard().put("STORED_CURRENT_SHAPE", null);
            layer.getBlackboard().put("STORED_CURRENT_STATE", null);
        }
    }

    public void cancelHideSelection(ILayer selectedLayer) {
        if (selectedLayer == null) {
            return;
        }
        IBlackboard properties = selectedLayer.getBlackboard();
        if (!PreferenceUtil.instance().hideSelectedLayers()) {
            properties.put("EDIT_FILTER_CACHE", null);
            ((ViewportPane)selectedLayer.getMap().getRenderManager().getMapDisplay()).repaint();
            return;
        }
        Filter filter = (Filter)properties.get("EDIT_FILTER_CACHE");
        if (filter == null) {
            return;
        }
        properties.put("EDIT_FILTER_CACHE", null);
        Envelope env = (Envelope)properties.get(EDIT_FEATURE_BOUNDS);
        properties.put(EDIT_FEATURE_BOUNDS, null);
        selectedLayer.refresh(env);
    }

    public void hideSelectedFeatures(EditToolHandler handler, ILayer selectedLayer) {
        Envelope env = new Envelope();
        HashSet<String> fids = new HashSet<String>();
        for (EditGeom geom : handler.getEditBlackboard(selectedLayer).getGeoms()) {
            if (env.isNull()) {
                env.init(geom.getShell().getEnvelope());
            } else {
                env.expandToInclude(geom.getShell().getEnvelope());
            }
            String fid = geom.getFeatureIDRef().get();
            if (fid == null) continue;
            fids.add(fid);
        }
        instance.refreshLayer(selectedLayer, fids, env, true, true);
    }

    public void refreshLayer(ILayer selectedLayer, SimpleFeature feature, Envelope refreshBounds, boolean forceRefresh, boolean hidefeature) {
        Set<String> fids = Collections.singleton(feature.getID());
        this.refreshLayer(selectedLayer, fids, refreshBounds, forceRefresh, hidefeature);
    }

    public void refreshLayer(ILayer selectedLayer, Set<String> fids, Envelope refreshBounds, boolean forceRefresh, boolean hidefeature) {
        if (selectedLayer == null) {
            return;
        }
        IBlackboard properties = selectedLayer.getBlackboard();
        if (!PreferenceUtil.instance().hideSelectedLayers()) {
            properties.put("EDIT_FILTER_CACHE", null);
            if (forceRefresh || !refreshBounds.isNull()) {
                selectedLayer.refresh(refreshBounds);
            }
            ((ViewportPane)selectedLayer.getMap().getRenderManager().getMapDisplay()).repaint();
            return;
        }
        if (!forceRefresh && fids.isEmpty()) {
            return;
        }
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        boolean modified = false;
        for (String fid : fids) {
            if (fid == null) continue;
            if (hidefeature) {
                this.setAffectedArea(refreshBounds, properties);
                modified = this.addFidToExcludeFilter(properties, fid, filterFactory) || modified;
                continue;
            }
            boolean bl = modified = this.removeFidFromExcludeFilter(properties, fid, filterFactory) || modified;
        }
        if ((refreshBounds != null || forceRefresh) && modified) {
            selectedLayer.refresh(refreshBounds);
        }
    }

    private boolean removeFidFromExcludeFilter(IBlackboard properties, String fid, FilterFactory filterFactory) {
        Filter filter = (Filter)properties.get("EDIT_FILTER_CACHE");
        ExcludeFilter f = Filter.EXCLUDE;
        boolean modified = false;
        if (filter instanceof Id) {
            Id fidFilter = (Id)filter;
            HashSet ids = new HashSet(fidFilter.getIdentifiers());
            Iterator iter = ids.iterator();
            while (iter.hasNext()) {
                Identifier element = (Identifier)iter.next();
                Object id = element.getID();
                if (!id.equals(fid)) continue;
                iter.remove();
                break;
            }
            f = filterFactory.id(ids);
            if (fidFilter.getIDs().toArray(new String[0]).length == 0) {
                f = Filter.EXCLUDE;
            }
            modified = true;
        } else if (filter != null) {
            f = filterFactory.id(FeatureUtils.stringToId((FilterFactory)filterFactory, (String)fid));
            f = filterFactory.not((Filter)f);
            f = filterFactory.or((Filter)f, filter);
            modified = true;
        }
        if (f == Filter.EXCLUDE) {
            f = null;
        }
        properties.put("EDIT_FILTER_CACHE", (Object)f);
        return modified;
    }

    private boolean addFidToExcludeFilter(IBlackboard properties, String fid, FilterFactory filterFactory) {
        Id f;
        Filter filter = (Filter)properties.get("EDIT_FILTER_CACHE");
        boolean modified = false;
        if (filter instanceof Id) {
            Id fidFilter = (Id)filter;
            HashSet<FeatureId> ids = new HashSet<FeatureId>(fidFilter.getIdentifiers());
            ids.add(filterFactory.featureId(fid));
            f = filterFactory.id(ids);
            modified = true;
        } else {
            f = filterFactory.id(FeatureUtils.stringToId((FilterFactory)filterFactory, (String)fid));
            if (filter != null) {
                f = filterFactory.or((Filter)f, filter);
            }
            modified = true;
        }
        properties.put("EDIT_FILTER_CACHE", (Object)f);
        return modified;
    }

    private void setAffectedArea(Envelope refreshBounds, IBlackboard properties) {
        Envelope bounds = (Envelope)properties.get(EDIT_FEATURE_BOUNDS);
        if (refreshBounds == null) {
            bounds = null;
        } else if (bounds == null) {
            bounds = new Envelope(refreshBounds);
        } else {
            bounds.expandToInclude(refreshBounds);
        }
        properties.put(EDIT_FEATURE_BOUNDS, (Object)bounds);
    }

    public EditGeom getGeomWithMouseOver(Collection<EditGeom> geoms, Point location, boolean treatUnknownAsPolygon) {
        EditGeom over = geoms.iterator().next();
        for (EditGeom geom : geoms) {
            PrimitiveShapeIterator iter = PrimitiveShapeIterator.getPathIterator(geom.getShell());
            if (iter.toShape().contains(location.getX(), location.getY())) {
                over = geom;
                break;
            }
            ClosestEdge edge = geom.getShell().getClosestEdge(location, treatUnknownAsPolygon);
            if (edge == null || !(edge.getDistanceToEdge() <= (double)PreferenceUtil.instance().getVertexRadius())) continue;
            over = geom;
            break;
        }
        return over;
    }

    public boolean selfIntersection(PrimitiveShape shape) {
        if (shape.getNumPoints() < 3) {
            return false;
        }
        int i = 1;
        while (i < shape.getNumPoints()) {
            Point current;
            Point last = shape.getPoint(i - 1);
            if (this.intersection(last, current = shape.getPoint(i), shape, i, shape.getNumPoints() - 1, false)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean intersection(Point point1, Point point2, PrimitiveShape shape, int startIndex, int endIndex) {
        return this.intersection(point1, point2, shape, startIndex, endIndex, true);
    }

    private boolean intersection(Point point1, Point point2, PrimitiveShape shape, int startIndex, int endIndex, boolean referenceLineIntersections) {
        int j = startIndex + 1;
        while (j < endIndex + 1) {
            Point last2 = shape.getPoint(j - 1);
            Point current2 = shape.getPoint(j);
            if (!last2.equals(point1)) {
                if (this.linesParallel(point1, point2, last2, current2)) {
                    if (this.sameDirection(point1, point2, last2, current2) && last2.equals(point2)) {
                        return true;
                    }
                } else {
                    Point intersectingLines = this.intersectingLines(point1, point2, last2, current2);
                    if (intersectingLines != null) {
                        Point endPoint2;
                        Point endPoint1;
                        if (referenceLineIntersections) {
                            endPoint1 = point1;
                            endPoint2 = point2;
                        } else {
                            endPoint1 = last2;
                            endPoint2 = current2;
                        }
                        if (!intersectingLines.equals(endPoint1) && !intersectingLines.equals(endPoint2)) {
                            return true;
                        }
                    }
                }
            }
            ++j;
        }
        return false;
    }

    private boolean sameDirection(Point last, Point current, Point last2, Point current2) {
        double length2;
        int dx1 = last.getX() - current.getX();
        int dy1 = last.getY() - current.getY();
        int dy2 = last2.getY() - current2.getY();
        int dx2 = last2.getX() - current2.getX();
        double length1 = Math.sqrt(dx1 * dx1 + dy1 * dy1);
        return (double)dx1 / length1 != (double)dx2 / (length2 = Math.sqrt(dx2 * dx2 + dy2 * dy2)) || (double)dy1 / length1 != (double)dy2 / length2;
    }

    private boolean linesParallel(Point line1P1, Point line1P2, Point line2P1, Point line2P2) {
        int A2;
        int B1 = line1P1.getX() - line1P2.getX();
        int B2 = line2P1.getX() - line2P2.getX();
        int A1 = line1P2.getY() - line1P1.getY();
        double det = A1 * B2 - (A2 = line2P2.getY() - line2P1.getY()) * B1;
        return det == 0.0;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$net$refractions$udig$tools$edit$support$SnapBehaviour() {
        if ($SWITCH_TABLE$net$refractions$udig$tools$edit$support$SnapBehaviour != null) {
            return $SWITCH_TABLE$net$refractions$udig$tools$edit$support$SnapBehaviour;
        }
        int[] nArray = new int[SnapBehaviour.values().length];
        try {
            nArray[SnapBehaviour.ALL_LAYERS.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SnapBehaviour.CURRENT_LAYER.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SnapBehaviour.GRID.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SnapBehaviour.OFF.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SnapBehaviour.SELECTED.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$net$refractions$udig$tools$edit$support$SnapBehaviour = nArray;
        return nArray;
    }

    public static class EditToolHandlerShapeProvider
    implements IBlockingProvider<PrimitiveShape> {
        private EditToolHandler handler;

        public EditToolHandlerShapeProvider(EditToolHandler handler) {
            this.handler = handler;
        }

        public PrimitiveShape get(IProgressMonitor monitor, Object ... params) {
            return this.handler.getCurrentShape();
        }
    }

    private static class FireEventsCommand
    extends AbstractCommand
    implements UndoableMapCommand {
        private EditBlackboard bb;

        FireEventsCommand(EditBlackboard bb) {
            this.bb = bb;
        }

        public void run(IProgressMonitor monitor) throws Exception {
            this.bb.fireBatchedEvents();
        }

        public String getName() {
            return null;
        }

        public void rollback(IProgressMonitor monitor) throws Exception {
        }
    }

    public static class MinFinder {
        private Point centerPoint;
        private Point currentMin;
        private double distance;
        private Coordinate centerCoord;
        private Coordinate minCoord;

        public MinFinder(Point centerPoint) {
            if (centerPoint == null) {
                throw new NullPointerException("centerPoint cannot be null");
            }
            this.centerPoint = centerPoint;
        }

        public MinFinder(Coordinate coord) {
            this.centerCoord = coord;
        }

        public Point getMin() {
            return this.currentMin;
        }

        public Coordinate getMinCoord() {
            return this.minCoord;
        }

        public void add(Point p) {
            if (p == null || p.equals(this.centerPoint)) {
                return;
            }
            if (this.currentMin == null) {
                this.currentMin = p;
                this.distance = this.dist(p);
                return;
            }
            double dist = this.dist(p);
            if (dist < this.distance) {
                this.currentMin = p;
                this.distance = dist;
            }
        }

        public double dist(Point p) {
            double x = this.centerPoint.getX() - p.getX();
            double y = this.centerPoint.getY() - p.getY();
            return Math.sqrt(x * x + y * y);
        }

        public void add(Coordinate p) {
            if (p == null || p.equals((Object)this.centerCoord)) {
                return;
            }
            if (this.minCoord == null) {
                this.minCoord = p;
                this.distance = this.dist(p);
                return;
            }
            double dist = this.dist(p);
            if (dist < this.distance) {
                this.minCoord = p;
                this.distance = dist;
            }
        }

        public double dist(Coordinate p) {
            double x = this.centerCoord.x - p.x;
            double y = this.centerCoord.y - p.y;
            return Math.sqrt(x * x + y * y);
        }
    }

    private static class StartBatchingCommand
    extends AbstractCommand
    implements UndoableMapCommand {
        private EditBlackboard bb;

        StartBatchingCommand(EditBlackboard bb) {
            this.bb = bb;
        }

        public void run(IProgressMonitor monitor) throws Exception {
            this.bb.startBatchingEvents();
        }

        public String getName() {
            return null;
        }

        public void rollback(IProgressMonitor monitor) throws Exception {
        }
    }

    public static class StaticEditGeomProvider
    implements IBlockingProvider<EditGeom> {
        private EditGeom geom;

        public StaticEditGeomProvider(EditGeom geom) {
            this.geom = geom;
        }

        public EditGeom get(IProgressMonitor monitor, Object ... params) {
            return this.geom;
        }
    }

    public static class StaticShapeProvider
    implements IBlockingProvider<PrimitiveShape> {
        private PrimitiveShape shape;

        public StaticShapeProvider(PrimitiveShape shape) {
            this.shape = shape;
        }

        public PrimitiveShape get(IProgressMonitor monitor, Object ... params) {
            return this.shape;
        }
    }
}

