/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.support;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.support.ClosestEdge;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeomSelection;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import net.refractions.udig.tools.edit.support.Selection;
import net.refractions.udig.tools.edit.support.ShapeType;

public class EditGeom
implements Iterable<PrimitiveShape> {
    private final PrimitiveShape shell;
    private final List<PrimitiveShape> holes = Collections.synchronizedList(new ArrayList());
    EditBlackboard owner;
    private final AtomicReference<ShapeType> shapeType = new AtomicReference();
    private final AtomicReference<String> featureID;
    private AtomicReference<Boolean> changed;
    boolean initializing;
    private Envelope featureBBox;

    public EditGeom(EditBlackboard owner, String featureId2) {
        this.shapeType.set(ShapeType.UNKNOWN);
        this.featureID = new AtomicReference();
        this.changed = new AtomicReference();
        this.featureBBox = null;
        this.owner = owner;
        this.shell = new PrimitiveShape(this);
        this.featureID.set(featureId2);
        this.changed.set(false);
    }

    public EditGeom(EditBlackboard owner, String featureId, Envelope featureBounds) {
        this.shapeType.set(ShapeType.UNKNOWN);
        this.featureID = new AtomicReference();
        this.changed = new AtomicReference();
        this.featureBBox = null;
        this.owner = owner;
        this.shell = new PrimitiveShape(this);
        this.featureID.set(featureId);
        this.changed.set(false);
        this.featureBBox = featureBounds;
    }

    public EditGeom(EditGeom geom) {
        this.shapeType.set(ShapeType.UNKNOWN);
        this.featureID = new AtomicReference();
        this.changed = new AtomicReference();
        this.featureBBox = null;
        this.shell = new PrimitiveShape(geom.getShell());
        for (PrimitiveShape hole : geom.getHoles()) {
            this.holes.add(new PrimitiveShape(hole));
        }
        this.owner = geom.owner;
    }

    public PrimitiveShape getShell() {
        return this.shell;
    }

    public List<PrimitiveShape> getHoles() {
        return this.holes;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.featureID.get());
        buffer.append(" ");
        buffer.append(this.shapeType);
        buffer.append(" ");
        buffer.append(this.shell.toString());
        buffer.append("{");
        int i = 0;
        int numHoles = this.holes.size();
        while (i < numHoles) {
            buffer.append(this.holes.get(i).toString());
            ++i;
        }
        buffer.append("}");
        return buffer.toString();
    }

    public PrimitiveShape newHole() {
        PrimitiveShape hole = new PrimitiveShape(this);
        hole.type = "HOLE";
        this.holes.add(hole);
        return hole;
    }

    public AtomicReference<String> getFeatureIDRef() {
        return this.featureID;
    }

    public ShapeType getShapeType() {
        return this.shapeType.get();
    }

    public void setShapeType(ShapeType shapeType) {
        this.shapeType.set(shapeType);
    }

    @Override
    public Iterator<PrimitiveShape> iterator() {
        return new Iterator<PrimitiveShape>(){
            boolean shellAccessed = false;
            Iterator<PrimitiveShape> holeIter;
            {
                this.holeIter = EditGeom.this.holes.iterator();
            }

            @Override
            public boolean hasNext() {
                return !this.shellAccessed || this.holeIter.hasNext();
            }

            @Override
            public PrimitiveShape next() {
                if (!this.shellAccessed) {
                    this.shellAccessed = true;
                    return EditGeom.this.shell;
                }
                return this.holeIter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not allowed");
            }
        };
    }

    public EditBlackboard getEditBlackboard() {
        return this.owner;
    }

    public Envelope getFeatureEnvelope() {
        return this.featureBBox;
    }

    public boolean isChanged() {
        return this.changed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChanged(boolean changed) {
        if (this.changed.get().booleanValue() && !changed) {
            EditBlackboard editBlackboard = this.owner;
            synchronized (editBlackboard) {
                Envelope envelope = new Envelope();
                int i = 0;
                while (i < this.shell.getNumCoords()) {
                    envelope.expandToInclude(this.shell.getCoord(i));
                    ++i;
                }
                this.featureBBox = envelope;
            }
        }
        this.changed.set(changed);
    }

    public Selection createSelection() {
        return new EditGeomSelection(this);
    }

    public void assertValid() {
        if (!EditPlugin.isDebugging("net.refractions.udig.tools.edit/debug/assertions")) {
            return;
        }
        for (PrimitiveShape shape : this) {
            shape.assertValid();
        }
    }

    public boolean hasVertex(Point point) {
        if (this.shapeType.get() == ShapeType.POLYGON) {
            for (PrimitiveShape shape : this) {
                if (!shape.hasVertex(point)) continue;
                return true;
            }
            return false;
        }
        return this.shell.hasVertex(point);
    }

    public ClosestEdge getClosestEdge(Point point, boolean treatUnknownAsPolygon) {
        assert (this.shapeType.get() != ShapeType.POINT);
        ClosestEdge closest = this.shell.getClosestEdge(point, treatUnknownAsPolygon);
        if ((this.shapeType.get() == ShapeType.POLYGON || this.shapeType.get() == ShapeType.UNKNOWN && treatUnknownAsPolygon) && this.shell.contains(point, treatUnknownAsPolygon)) {
            for (PrimitiveShape shape : this.holes) {
                ClosestEdge current = shape.getClosestEdge(point, treatUnknownAsPolygon);
                if (closest == null) {
                    closest = current;
                    continue;
                }
                if (current == null || !(current.distanceToEdge < closest.distanceToEdge)) continue;
                closest = current;
            }
        }
        return closest;
    }

    public Point overVertex(Point point, int radius) {
        for (PrimitiveShape shape : this) {
            Point p = shape.overVertex(point, radius);
            if (p == null) continue;
            return p;
        }
        return null;
    }
}

