/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.support;

import java.awt.geom.PathIterator;
import java.util.Iterator;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.EditGeomPointIterator;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.Selection;

public class ControlPointPathIterator
implements PathIterator {
    int count = 0;
    int x = 1;
    int y = 1;
    int rectPos = 0;
    private final Iterator<Point> points;
    private final int xRadius;
    private final int yRadius;

    public ControlPointPathIterator(EditGeom geom, boolean selection, int width, int height) {
        Selection selectionCollection = geom.createSelection();
        int xRadius = width / 2;
        int yRadius = height / 2;
        if (xRadius < 1) {
            xRadius = 1;
        }
        if (yRadius < 1) {
            yRadius = 1;
        }
        this.xRadius = xRadius;
        this.yRadius = yRadius;
        this.points = selection ? selectionCollection.iterator() : new EditGeomPointIterator(geom, selectionCollection);
        if (this.points.hasNext()) {
            Point next = this.points.next();
            this.x = next.getX();
            this.y = next.getY();
        } else {
            this.rectPos = 6;
        }
    }

    @Override
    public int currentSegment(float[] coords) {
        double[] c = new double[2];
        int result = this.currentSegment(c);
        coords[0] = (float)c[0];
        coords[1] = (float)c[1];
        return result;
    }

    @Override
    public int currentSegment(double[] coords) {
        switch (this.rectPos) {
            case 0: {
                coords[0] = this.x - this.xRadius;
                coords[1] = this.y - this.yRadius;
                break;
            }
            case 1: {
                coords[0] = this.x + this.xRadius;
                coords[1] = this.y - this.yRadius;
                break;
            }
            case 2: {
                coords[0] = this.x + this.xRadius;
                coords[1] = this.y + this.yRadius;
                break;
            }
            case 3: {
                coords[0] = this.x - this.xRadius;
                coords[1] = this.y + this.yRadius;
                break;
            }
            case 4: {
                coords[0] = this.x - this.xRadius;
                coords[1] = this.y - this.yRadius;
                break;
            }
            case 5: {
                return 4;
            }
            default: {
                return 0;
            }
        }
        if (this.rectPos == 0) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getWindingRule() {
        return 0;
    }

    @Override
    public boolean isDone() {
        return !this.points.hasNext() && this.rectPos > 5;
    }

    @Override
    public void next() {
        ++this.rectPos;
        if (this.rectPos == 5 && this.points.hasNext()) {
            this.rectPos = 0;
            ++this.count;
            Point next = this.points.next();
            this.x = next.getX();
            this.y = next.getY();
        }
    }
}

