/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.support;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;

public abstract class AbstractShapeIterator
implements PathIterator {
    private PrimitiveShape pointShape;
    protected PrimitiveShape shape;
    protected Iterator<Point> points;
    protected Point currentPoint;
    protected Point nextPoint;
    private PrimitiveShape trueShape;

    protected AbstractShapeIterator(PrimitiveShape shape) {
        this.trueShape = shape;
    }

    public synchronized Shape toShape() {
        this.reset();
        GeneralPath path = new GeneralPath();
        path.append(this, false);
        return path;
    }

    public synchronized void reset() {
        this.currentPoint = null;
        this.shape = this.trueShape.getNumPoints() == 1 ? this.getPointShape() : this.trueShape;
        this.points = this.shape.iterator();
        this.nextPoint = null;
    }

    private synchronized PrimitiveShape getPointShape() {
        if (this.pointShape == null) {
            this.pointShape = new PrimitiveShape(this.trueShape.getEditGeom());
            Point point = this.trueShape.getPoint(0);
            this.pointShape.getEditGeom().initializing = true;
            Point valueOf = Point.valueOf(point.getX() - 2, point.getY() - 2);
            this.pointShape.getMutator().addPoint(valueOf, null);
            valueOf = Point.valueOf(point.getX() + 2, point.getY() - 2);
            this.pointShape.getMutator().addPoint(valueOf, null);
            valueOf = Point.valueOf(point.getX() + 2, point.getY() + 2);
            this.pointShape.getMutator().addPoint(valueOf, null);
            valueOf = Point.valueOf(point.getX() - 2, point.getY() + 2);
            this.pointShape.getMutator().addPoint(valueOf, null);
            valueOf = Point.valueOf(point.getX() - 2, point.getY() - 2);
            this.pointShape.getMutator().addPoint(valueOf, null);
            this.pointShape.getEditGeom().initializing = false;
        }
        return this.pointShape;
    }

    @Override
    public int getWindingRule() {
        return 0;
    }

    @Override
    public boolean isDone() {
        return this.isDoneInternal();
    }

    private boolean isDoneInternal() {
        if (this.nextPoint != null) {
            return false;
        }
        if (this.points.hasNext()) {
            this.nextPoint = this.points.next();
            return false;
        }
        return true;
    }

    @Override
    public void next() {
        try {
            this.nextPoint = null;
            if (this.points.hasNext()) {
                if (this.isDone()) {
                    return;
                }
                this.currentPoint = this.nextPoint;
            } else {
                this.isDone();
                this.currentPoint = null;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NoSuchElementException("Shape is done, make sure to check isDone before calling next()");
        }
    }

    @Override
    public int currentSegment(float[] coords) {
        int result = 1;
        if (this.currentPoint == null) {
            coords[0] = this.nextPoint.getX();
            coords[1] = this.nextPoint.getY();
            return 0;
        }
        coords[0] = this.currentPoint.getX();
        coords[1] = this.currentPoint.getY();
        return result;
    }

    @Override
    public int currentSegment(double[] coords) {
        int result = 1;
        if (this.currentPoint == null) {
            coords[0] = this.nextPoint.getX();
            coords[1] = this.nextPoint.getY();
            return 0;
        }
        coords[0] = this.currentPoint.getX();
        coords[1] = this.currentPoint.getY();
        return result;
    }
}

