/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.support;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import net.refractions.udig.ui.graphics.AWTSWTImageUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;

public abstract class AbstractPathIterator
implements PathIterator {
    protected final EditGeom geom;
    private Iterator<PrimitiveShape> shapes;
    protected Iterator<Point> points;
    protected Point currentPoint;
    protected Point nextPoint;
    protected PrimitiveShape currentShape;

    protected AbstractPathIterator(EditGeom shape) {
        this.geom = shape;
    }

    public Shape toShape() {
        Shape createPoint;
        this.prepareToPath();
        if (this.geom.getShell().getNumPoints() == 1 && (createPoint = this.createPoint()) != null) {
            return createPoint;
        }
        GeneralPath path = new GeneralPath(0);
        path.append(this, false);
        return path;
    }

    public Path toPath(Device device) {
        Path createPoint;
        this.prepareToPath();
        if (this.geom.getShell().getNumPoints() == 1 && (createPoint = this.createPointPath(device)) != null) {
            return createPoint;
        }
        return AWTSWTImageUtils.createPath((PathIterator)this, (Device)device);
    }

    private void prepareToPath() {
        this.currentPoint = null;
        this.points = null;
        this.nextPoint = null;
        this.currentShape = null;
        this.shapes = this.geom.iterator();
    }

    protected Shape createPoint() {
        Point point = this.geom.getShell().getPoint(0);
        return new Rectangle(point.getX() - 2, point.getY() - 2, 4, 4);
    }

    protected Path createPointPath(Device device) {
        Point point = this.geom.getShell().getPoint(0);
        Path path = new Path(device);
        path.addRectangle((float)(point.getX() - 2), (float)(point.getY() - 2), 4.0f, 4.0f);
        return path;
    }

    @Override
    public int getWindingRule() {
        return 0;
    }

    @Override
    public boolean isDone() {
        return this.isDoneInternal();
    }

    /*
     * Unable to fully structure code
     */
    private boolean isDoneInternal() {
        if (this.nextPoint != null) {
            return false;
        }
        if (this.points == null || !this.points.hasNext()) ** GOTO lbl11
        this.nextPoint = this.points.next();
        return false;
lbl-1000:
        // 1 sources

        {
            this.currentShape = this.shapes.next();
            this.points = this.currentShape.iterator();
            if (!this.points.hasNext()) continue;
            this.nextPoint = this.points.next();
            break;
lbl11:
            // 2 sources

            ** while (this.shapes.hasNext())
        }
lbl12:
        // 2 sources

        return this.nextPoint == null;
    }

    @Override
    public void next() {
        try {
            this.nextPoint = null;
            if (this.points.hasNext()) {
                if (this.isDone()) {
                    return;
                }
                this.currentPoint = this.nextPoint;
            } else {
                this.isDone();
                this.currentPoint = null;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NoSuchElementException("Shape is done, make sure to check isDone before calling next()");
        }
    }

    @Override
    public int currentSegment(float[] coords) {
        int result = 1;
        if (this.currentPoint == null) {
            coords[0] = this.nextPoint.getX();
            coords[1] = this.nextPoint.getY();
            return 0;
        }
        coords[0] = this.currentPoint.getX();
        coords[1] = this.currentPoint.getY();
        return result;
    }

    @Override
    public int currentSegment(double[] coords) {
        float[] floats = new float[coords.length];
        int result = this.currentSegment(floats);
        System.arraycopy(floats, 0, coords, 0, coords.length);
        return result;
    }
}

