/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.impl;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.List;
import java.util.Set;
import net.refractions.udig.tools.edit.AbstractEditTool;
import net.refractions.udig.tools.edit.Activator;
import net.refractions.udig.tools.edit.Behaviour;
import net.refractions.udig.tools.edit.EditToolConfigurationHelper;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EnablementBehaviour;
import net.refractions.udig.tools.edit.activator.ClearCurrentSelectionActivator;
import net.refractions.udig.tools.edit.activator.EditStateListenerActivator;
import net.refractions.udig.tools.edit.activator.ResetHandlerActivator;
import net.refractions.udig.tools.edit.activator.SetRenderingFilter;
import net.refractions.udig.tools.edit.behaviour.CreateShapeBehaviour;
import net.refractions.udig.tools.edit.behaviour.DefaultCancelBehaviour;
import net.refractions.udig.tools.edit.behaviour.accept.AcceptChangesBehaviour;
import net.refractions.udig.tools.edit.enablement.ValidToolDetectionActivator;
import net.refractions.udig.tools.edit.enablement.WithinLegalLayerBoundsBehaviour;
import net.refractions.udig.tools.edit.support.ShapeType;

public class RectangleTool
extends AbstractEditTool {
    @Override
    protected void initEnablementBehaviours(List<EnablementBehaviour> helper) {
        helper.add(new WithinLegalLayerBoundsBehaviour());
        helper.add(new ValidToolDetectionActivator(new Class[]{Geometry.class, MultiLineString.class, LineString.class, LinearRing.class, Polygon.class, MultiPolygon.class}));
    }

    @Override
    protected void initActivators(Set<Activator> activators) {
        activators.add(new EditStateListenerActivator());
        activators.add(new ResetHandlerActivator());
        activators.add(new SetRenderingFilter());
        activators.add(new ClearCurrentSelectionActivator());
    }

    @Override
    protected void initAcceptBehaviours(List<Behaviour> acceptBehaviours) {
        acceptBehaviours.add(new AcceptChangesBehaviour(Polygon.class, true){

            @Override
            public boolean isValid(EditToolHandler handler) {
                return super.isValid(handler) && handler.getCurrentGeom().getShapeType() == ShapeType.POLYGON;
            }
        });
        acceptBehaviours.add(new AcceptChangesBehaviour(LinearRing.class, true){

            @Override
            public boolean isValid(EditToolHandler handler) {
                return super.isValid(handler) && handler.getCurrentGeom().getShapeType() == ShapeType.LINE;
            }
        });
    }

    @Override
    protected void initCancelBehaviours(List<Behaviour> cancelBehaviours) {
        cancelBehaviours.add(new DefaultCancelBehaviour());
    }

    @Override
    protected void initEventBehaviours(EditToolConfigurationHelper helper) {
        helper.add(new CreateShapeBehaviour(this.getShapeFactory()));
        helper.done();
    }

    protected CreateShapeBehaviour.ShapeFactory getShapeFactory() {
        return new CreateShapeBehaviour.ShapeFactory(){

            @Override
            public GeneralPath create(int width, int height) {
                GeneralPath path = new GeneralPath();
                path.append(new Rectangle(width, height).getPathIterator(new AffineTransform()), false);
                return path;
            }
        };
    }
}

