/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.handler;

import net.refractions.udig.project.IMap;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.ui.AnimationUpdater;
import net.refractions.udig.project.ui.IAnimation;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.activator.GridActivator;
import net.refractions.udig.tools.edit.animation.MessageBubble;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.SnapBehaviour;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class SnapBehaviourCommandHandler
extends AbstractHandler
implements IHandler {
    private final IMapDisplay mapDisplay;
    private MessageBubble messageBubble;
    private final IMap map;
    private final GridActivator activator = new GridActivator();

    public SnapBehaviourCommandHandler(IMapDisplay display, IMap map) {
        this.mapDisplay = display;
        this.map = map;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        SnapBehaviour previousBehaviour = PreferenceUtil.instance().getSnapBehaviour();
        switch (previousBehaviour) {
            case OFF: {
                this.activator.hideGrid(this.map);
                previousBehaviour = SnapBehaviour.CURRENT_LAYER;
                break;
            }
            case CURRENT_LAYER: {
                this.activator.hideGrid(this.map);
                previousBehaviour = SnapBehaviour.ALL_LAYERS;
                break;
            }
            case ALL_LAYERS: {
                previousBehaviour = SnapBehaviour.GRID;
                this.activator.showGrid(this.map);
                break;
            }
            case GRID: {
                previousBehaviour = SnapBehaviour.OFF;
                this.activator.hideGrid(this.map);
                break;
            }
        }
        PreferenceUtil.instance().setSnapBehaviour(previousBehaviour);
        this.displayNewStatus(previousBehaviour);
        return null;
    }

    private void displayNewStatus(SnapBehaviour snapBehaviour) {
        Display display = Display.getCurrent();
        String message = null;
        switch (snapBehaviour) {
            case OFF: {
                message = Messages.SnapBehaviourCommandHandler_off;
                break;
            }
            case SELECTED: {
                message = Messages.SnapBehaviourCommandHandler_selected;
                break;
            }
            case CURRENT_LAYER: {
                message = Messages.SnapBehaviourCommandHandler_current;
                break;
            }
            case ALL_LAYERS: {
                message = Messages.SnapBehaviourCommandHandler_all;
                break;
            }
            case GRID: {
                message = Messages.SnapBehaviourCommandHandler_grid;
                break;
            }
        }
        if (message != null) {
            if (this.messageBubble != null && this.messageBubble.isValid()) {
                this.messageBubble.setValid(false);
            }
            Control control = (Control)this.mapDisplay;
            Point mouseLocation = control.toControl(display.getCursorLocation());
            this.messageBubble = new MessageBubble(mouseLocation.x, mouseLocation.y, message, PreferenceUtil.instance().getMessageDisplayDelay());
            AnimationUpdater.runTimer((IMapDisplay)this.mapDisplay, (IAnimation)this.messageBubble);
        }
    }
}

