/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.handler;

import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.ui.AnimationUpdater;
import net.refractions.udig.project.ui.IAnimation;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.animation.MessageBubble;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class AdvancedBehaviourCommandHandler
extends AbstractHandler
implements IHandler {
    private IMapDisplay mapDisplay;
    private MessageBubble messageBubble;

    public AdvancedBehaviourCommandHandler(IMapDisplay mapDisplay) {
        this.mapDisplay = mapDisplay;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        PreferenceUtil.instance().setAdvancedEditingActive(!PreferenceUtil.instance().isAdvancedEditingActive());
        this.displayNewStatus();
        return null;
    }

    private void displayNewStatus() {
        Display display = Display.getCurrent();
        String message = null;
        boolean active = PreferenceUtil.instance().isAdvancedEditingActive();
        message = active ? Messages.AdvancedBehaviourCommandHandler_enabledLabel : Messages.AdvancedBehaviourCommandHandler_disabledLabel;
        if (message != null) {
            if (this.messageBubble != null && this.messageBubble.isValid()) {
                this.messageBubble.setValid(false);
            }
            Control control = (Control)this.mapDisplay;
            Point mouseLocation = control.toControl(display.getCursorLocation());
            this.messageBubble = new MessageBubble(mouseLocation.x, mouseLocation.y, message, PreferenceUtil.instance().getMessageDisplayDelay());
            AnimationUpdater.runTimer((IMapDisplay)this.mapDisplay, (IAnimation)this.messageBubble);
        }
    }
}

