/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.enablement;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EnablementBehaviour;
import net.refractions.udig.tools.edit.EventType;
import org.opengis.referencing.operation.MathTransform;

public class WithinLegalLayerBoundsBehaviour
implements EnablementBehaviour {
    Map<ILayer, Envelope> cache = new WeakHashMap<ILayer, Envelope>();
    private EditState previousState = EditState.NONE;

    private boolean canTransformTo(ILayer selectedLayer, Coordinate world) {
        MathTransform t;
        try {
            t = selectedLayer.mapToLayerTransform();
        }
        catch (IOException e1) {
            throw (RuntimeException)new RuntimeException().initCause(e1);
        }
        try {
            double[] dest = new double[2];
            t.transform(new double[]{world.x, world.y}, 0, dest, 0, 1);
            return !Double.isNaN(dest[0]) && !Double.isNaN(dest[1]) && !Double.isInfinite(dest[0]) && !Double.isInfinite(dest[1]);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public String isEnabled(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        if (eventType != EventType.MOVED && eventType != EventType.ENTERED) {
            return null;
        }
        ILayer editLayer = handler.getEditLayer();
        Envelope env = this.cache.get(editLayer);
        Coordinate world = handler.getContext().pixelToWorld(e.x, e.y);
        if (env == null || !env.contains(world)) {
            if (this.canTransformTo(editLayer, world)) {
                if (env == null) {
                    env = new Envelope();
                }
                env.expandToInclude(world);
            } else {
                return "Cannot edit.  Either in a bad projection for editing layer or out of the bounds for the layer";
            }
        }
        return null;
    }
}

