/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.enablement;

import net.refractions.udig.project.IEditManager;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.Interaction;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.EditManager;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EnablementBehaviour;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.geotools.data.FeatureStore;

public class ValidToolDetectionActivator
implements EnablementBehaviour {
    private final Class[] legalClasses;
    private ILayer lastLayer;

    public ValidToolDetectionActivator(Class[] classes) {
        Class[] c = new Class[]{};
        if (classes != null) {
            c = new Class[classes.length];
            System.arraycopy(classes, 0, c, 0, c.length);
        }
        this.legalClasses = c;
    }

    private String detectCompatibility(EditToolHandler handler, IEditManager editManager) {
        ILayer selectedLayer = editManager.getSelectedLayer();
        if (((EditManager)editManager).isEditLayerLocked()) {
            selectedLayer = editManager.getEditLayer();
        }
        if (!selectedLayer.hasResource(FeatureStore.class)) {
            return Messages.ValidToolDetectionActivator_warning1;
        }
        if (!selectedLayer.getInteraction(Interaction.EDIT)) {
            return this.openQuestion(handler, Messages.ValidToolDetectionActivator_question, selectedLayer);
        }
        Class geomType = selectedLayer.getSchema().getGeometryDescriptor().getType().getBinding();
        boolean acceptable = false;
        Class[] classArray = this.legalClasses;
        int n = this.legalClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class type = classArray[n2];
            if (geomType.isAssignableFrom(type)) {
                acceptable = true;
                break;
            }
            ++n2;
        }
        if (!acceptable) {
            return Messages.ValidToolDetectionActivator_warning2;
        }
        return null;
    }

    private String openQuestion(final EditToolHandler handler, final String string, final ILayer layer) {
        final String[] warning = new String[1];
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        PlatformGIS.syncInDisplayThread((Display)shell.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                boolean decision = MessageDialog.openQuestion((Shell)shell, (String)Messages.ValidToolDetectionActivator_questionTitle, (String)string);
                if (decision) {
                    UndoableMapCommand command = handler.getContext().getBasicCommandFactory().createSetApplicabilityCommand(layer, Interaction.EDIT, true);
                    handler.getContext().sendASyncCommand((Command)command);
                } else {
                    warning[0] = Messages.ValidToolDetectionActivator_warning2;
                }
            }
        });
        return warning[0];
    }

    @Override
    public String isEnabled(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        if (eventType != EventType.MOVED && eventType != EventType.ENTERED || this.lastLayer == handler.getEditLayer()) {
            return null;
        }
        IEditManager editManager = handler.getContext().getEditManager();
        this.lastLayer = handler.getEditLayer();
        return this.detectCompatibility(handler, editManager);
    }
}

