/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands.selection;

import java.util.List;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.commands.ClearEditBlackboardCommand;
import net.refractions.udig.tools.edit.commands.DeselectEditGeomCommand;
import net.refractions.udig.tools.edit.commands.DeselectionStrategy;
import net.refractions.udig.tools.edit.commands.SelectionParameter;
import net.refractions.udig.tools.edit.commands.SetEditStateCommand;
import net.refractions.udig.tools.edit.commands.StartEditingCommand;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.ShapeType;
import org.eclipse.core.runtime.IProgressMonitor;

public class WriteModificationsStartEditingStrategy
implements DeselectionStrategy {
    private ShapeType typeToCreate;

    public WriteModificationsStartEditingStrategy(ShapeType typeToCreate) {
        this.typeToCreate = typeToCreate;
    }

    @Override
    public void run(IProgressMonitor monitor, SelectionParameter parameters, UndoableComposite commands) {
        EditToolHandler handler = parameters.handler;
        EditBlackboard editBlackboard = handler.getEditBlackboard(handler.getEditLayer());
        if (!parameters.event.isModifierDown(MapMouseEvent.MOD1_DOWN_MASK) && !parameters.event.isShiftDown() && parameters.permitClear) {
            this.writeModifiedFeaturesAndStartEditing(monitor, parameters, commands);
            commands.addCommand((MapCommand)handler.getContext().getEditFactory().createNullEditFeatureCommand());
            commands.addCommand((MapCommand)new ClearEditBlackboardCommand(handler, editBlackboard));
            commands.addCommand((MapCommand)new SetEditStateCommand(handler, EditState.NONE));
        }
        if (this.typeToCreate != null) {
            if (this.typeToCreate == ShapeType.POINT) {
                commands.addCommand((MapCommand)new StartEditingCommand(handler, parameters.event, this.typeToCreate, handler.getCurrentState()));
                commands.addCommand((MapCommand)handler.getCommand(handler.getAcceptBehaviours()));
            } else {
                commands.addCommand((MapCommand)new StartEditingCommand(handler, parameters.event, this.typeToCreate, EditState.CREATING));
            }
        }
    }

    private void writeModifiedFeaturesAndStartEditing(IProgressMonitor monitor, SelectionParameter parameters, UndoableComposite commands) {
        EditToolHandler handler = parameters.handler;
        EditBlackboard editBlackboard = handler.getEditBlackboard(handler.getEditLayer());
        if (this.hasDirtyGeom(handler)) {
            commands.addCommand((MapCommand)handler.getCommand(handler.getAcceptBehaviours()));
            commands.addCommand((MapCommand)new DeselectEditGeomCommand(handler, editBlackboard.getGeoms()));
        }
    }

    private boolean hasDirtyGeom(EditToolHandler handler) {
        if (handler.getCurrentGeom() != null && handler.getCurrentGeom().isChanged()) {
            return true;
        }
        List<EditGeom> geoms = handler.getEditBlackboard(handler.getEditLayer()).getGeoms();
        for (EditGeom geom : geoms) {
            if (!geom.isChanged()) continue;
            return true;
        }
        return false;
    }
}

