/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.commands.AddVertexCommand;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import net.refractions.udig.tools.edit.support.ShapeType;
import org.eclipse.core.runtime.IProgressMonitor;

public class StartEditingCommand
extends AbstractCommand
implements UndoableMapCommand {
    private final EditToolHandler handler;
    private EditState currentState;
    private PrimitiveShape currentShape;
    private ILayer layer;
    private ShapeType type;
    private EditState endState;
    private AddVertexCommand addVertexCommand;

    public StartEditingCommand(EditToolHandler handler, MapMouseEvent event, ShapeType type) {
        this(handler, event, type, EditState.CREATING);
    }

    public StartEditingCommand(EditToolHandler handler, MapMouseEvent event, ShapeType type, EditState endState) {
        this.handler = handler;
        this.layer = handler.getEditLayer();
        this.type = type;
        this.endState = endState;
        this.addVertexCommand = new AddVertexCommand(handler, handler.getEditBlackboard(this.layer), Point.valueOf(event.x, event.y));
    }

    public void run(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(Messages.StartEditingCommand_name, 32);
        monitor.worked(2);
        EditBlackboard editBlackboard = this.handler.getEditBlackboard(this.layer);
        EditGeom editGeom = editBlackboard.getGeoms().get(0);
        if (editGeom.getShell().getNumPoints() > 0) {
            editGeom = editBlackboard.newGeom(null, this.type);
        } else {
            editGeom.setShapeType(this.type);
        }
        this.currentState = this.handler.getCurrentState();
        this.currentShape = this.handler.getCurrentShape();
        this.handler.setCurrentShape(editGeom.getShell());
        this.handler.setCurrentState(this.endState);
        this.addVertexCommand.setMap(this.handler.getContext().getMap());
        this.addVertexCommand.run(monitor);
        monitor.done();
    }

    public String getName() {
        return Messages.StartEditingCommand_name;
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(Messages.StartEditingCommand_undo, 32);
        monitor.worked(2);
        this.handler.setCurrentState(this.currentState);
        this.handler.setCurrentShape(this.currentShape);
        monitor.done();
    }
}

