/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.refractions.udig.core.IBlockingProvider;
import net.refractions.udig.core.internal.FeatureUtils;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.UndoableCommand;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.GeometryCreationUtil;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import net.refractions.udig.tools.edit.support.ShapeType;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.geotools.data.FeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.collection.AdaptorFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;

public class SplitLineCommand
extends AbstractCommand
implements MapCommand,
UndoableCommand {
    private EditBlackboard editBlackboard;
    private IBlockingProvider<PrimitiveShape> shapeProvider;
    private Set<Point> points;
    private PrimitiveShape oldshape;
    private IBlockingProvider<SimpleFeature> featureProvider;
    private IBlockingProvider<ILayer> layerProvider;
    private SimpleFeature oldFeature;
    private ILayer layer;
    private List<FeatureId> newFids = new ArrayList<FeatureId>();
    private boolean currentShapeSet = false;
    private Geometry oldGeometry;
    private EditGeom first;

    public SplitLineCommand(EditBlackboard editBlackboard, IBlockingProvider<PrimitiveShape> provider, IBlockingProvider<SimpleFeature> featureProvider, IBlockingProvider<ILayer> layerProvider, Set<Point> points) {
        this.editBlackboard = editBlackboard;
        this.shapeProvider = provider;
        this.layerProvider = layerProvider;
        this.featureProvider = featureProvider;
        this.points = points;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        EditGeom current;
        this.editBlackboard.startBatchingEvents();
        this.oldshape = (PrimitiveShape)this.shapeProvider.get((IProgressMonitor)new SubProgressMonitor(monitor, 1), new Object[0]);
        this.oldFeature = (SimpleFeature)this.featureProvider.get((IProgressMonitor)new SubProgressMonitor(monitor, 1), new Object[0]);
        this.oldGeometry = (Geometry)this.oldFeature.getDefaultGeometry();
        this.layer = (ILayer)this.layerProvider.get((IProgressMonitor)new SubProgressMonitor(monitor, 1), new Object[0]);
        this.editBlackboard.removeGeometries(Collections.singleton(this.oldshape.getEditGeom()));
        ShapeType shapeType = this.oldshape.getEditGeom().getShapeType();
        this.first = current = this.editBlackboard.newGeom(this.oldshape.getEditGeom().getFeatureIDRef().get(), shapeType);
        HashSet<EditGeom> addedGeoms = new HashSet<EditGeom>();
        int i = 0;
        while (i < this.oldshape.getNumPoints()) {
            this.addCoords(current.getShell(), i);
            if (current.getShell().getNumPoints() > 1 && i < this.oldshape.getNumPoints() - 1 && this.points.contains(this.oldshape.getPoint(i))) {
                current = this.editBlackboard.newGeom("newFeature" + System.currentTimeMillis(), shapeType);
                List<Coordinate> coords = this.oldshape.getCoordsAt(i);
                this.editBlackboard.addCoordinate(coords.get(coords.size() - 1), current.getShell());
                addedGeoms.add(current);
            }
            ++i;
        }
        this.editBlackboard.removeGeometries(addedGeoms);
        if (this.getCurrentShape() == this.oldshape) {
            this.currentShapeSet = true;
            this.setCurrentShape(this.first.getShell());
        }
        FeatureStore store = (FeatureStore)this.layer.getResource(FeatureStore.class, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.modifyOldFeature((FeatureStore<SimpleFeatureType, SimpleFeature>)store);
        this.createAndAddFeatures(addedGeoms, (FeatureStore<SimpleFeatureType, SimpleFeature>)store);
        this.editBlackboard.fireBatchedEvents();
    }

    private void modifyOldFeature(FeatureStore<SimpleFeatureType, SimpleFeature> store) throws IOException, IllegalAttributeException {
        FilterFactory fac = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        Id filter = fac.id(FeatureUtils.stringToId((FilterFactory)fac, (String)this.oldFeature.getID()));
        LineString g = GeometryCreationUtil.createGeom(LineString.class, this.first.getShell(), true);
        if (((SimpleFeatureType)store.getSchema()).getGeometryDescriptor().getType().getBinding().isAssignableFrom(MultiLineString.class)) {
            g = new GeometryFactory().createMultiLineString(new LineString[]{g});
        }
        store.modifyFeatures((AttributeDescriptor)((SimpleFeatureType)store.getSchema()).getGeometryDescriptor(), (Object)g, (Filter)filter);
        this.oldFeature.setDefaultGeometry((Object)g);
    }

    private void createAndAddFeatures(final Set<EditGeom> addedGeoms, final FeatureStore<SimpleFeatureType, SimpleFeature> store) throws IOException {
        this.newFids = store.addFeatures((FeatureCollection)new AdaptorFeatureCollection("createAndAddCollection", (SimpleFeatureType)store.getSchema()){

            public int size() {
                return addedGeoms.size() - 1;
            }

            protected Iterator openIterator() {
                final Iterator iter = addedGeoms.iterator();
                return new Iterator(){
                    GeometryFactory factory = new GeometryFactory();

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    public Object next() {
                        List attrs = SplitLineCommand.this.oldFeature.getAttributes();
                        try {
                            SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)((SimpleFeatureType)store.getSchema()), (List)attrs, (String)("copyOf" + SplitLineCommand.this.oldFeature.getID()));
                            LineString geom = GeometryCreationUtil.createGeom(LineString.class, ((EditGeom)iter.next()).getShell(), true);
                            if (this.getSchema().getGeometryDescriptor().getType().getBinding().isAssignableFrom(MultiLineString.class)) {
                                geom = this.factory.createMultiLineString(new LineString[]{geom});
                            }
                            feature.setDefaultGeometry((Object)geom);
                            return feature;
                        }
                        catch (IllegalAttributeException e) {
                            throw (RuntimeException)new RuntimeException().initCause(e);
                        }
                    }

                    @Override
                    public void remove() {
                    }
                };
            }

            protected void closeIterator(Iterator close) {
            }
        });
    }

    private void setCurrentShape(PrimitiveShape shape) {
        this.getMap().getBlackboard().put("EDIT_TOOL_HANDLER_CURRENT_SHAPE_KEY_872839", (Object)shape);
    }

    private PrimitiveShape getCurrentShape() {
        return (PrimitiveShape)this.getMap().getBlackboard().get("EDIT_TOOL_HANDLER_CURRENT_SHAPE_KEY_872839");
    }

    private void addCoords(PrimitiveShape current, int i) {
        List<Coordinate> coords = this.oldshape.getCoordsAt(i);
        for (Coordinate coordinate : coords) {
            this.editBlackboard.addCoordinate(coordinate, current);
        }
    }

    public String getName() {
        return Messages.SplitLineCommand_name;
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        this.editBlackboard.removeGeometries(Collections.singleton(this.first));
        EditGeom newGeom = this.editBlackboard.newGeom(this.oldshape.getEditGeom().getFeatureIDRef().get(), this.oldshape.getEditGeom().getShapeType());
        int i = 0;
        while (i < this.oldshape.getNumCoords()) {
            this.editBlackboard.addCoordinate(this.oldshape.getCoord(i), newGeom.getShell());
            ++i;
        }
        if (this.currentShapeSet) {
            this.setCurrentShape(newGeom.getShell());
        }
        FeatureStore store = (FeatureStore)this.layer.getResource(FeatureStore.class, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        FilterFactory factory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        HashSet<FeatureId> ids = new HashSet<FeatureId>();
        for (FeatureId id : this.newFids) {
            ids.add(id);
        }
        Id filter = factory.id(ids);
        store.removeFeatures((Filter)filter);
        Geometry oldType = (Geometry)this.oldFeature.getDefaultGeometry();
        GeometryDescriptor newType = ((SimpleFeatureType)store.getSchema()).getGeometryDescriptor();
        store.modifyFeatures((AttributeDescriptor)newType, (Object)oldType, (Filter)factory.id(FeatureUtils.stringToId((FilterFactory)factory, (String)this.oldFeature.getID())));
        this.oldFeature.setDefaultGeometry((Object)this.oldGeometry);
        this.newFids.clear();
    }
}

