/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import com.vividsolutions.jts.geom.Envelope;
import java.util.Collections;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.tool.IToolContext;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;

public class SetEditFeatureCommand
extends AbstractCommand
implements UndoableMapCommand {
    EditToolHandler handler;
    Point clickPoint;
    PrimitiveShape shape;
    SimpleFeature oldFeature;
    ILayer oldLayer;
    private Layer editLayer;
    private Filter oldFilter;

    public SetEditFeatureCommand(EditToolHandler handler, MapMouseEvent e, PrimitiveShape shape) {
        this.handler = handler;
        this.clickPoint = Point.valueOf(e.x, e.y);
        this.shape = shape;
    }

    public SetEditFeatureCommand(EditToolHandler handler, Point clickPoint, PrimitiveShape shape) {
        this.handler = handler;
        this.clickPoint = clickPoint;
        this.shape = shape;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        IToolContext context = this.handler.getContext();
        java.awt.Point point = new java.awt.Point(this.clickPoint.getX(), this.clickPoint.getY());
        ReferencedEnvelope bbox = this.handler.getContext().getBoundingBox(point, 7);
        FeatureCollection fc = context.getFeaturesInBbox(this.handler.getEditLayer(), (Envelope)bbox);
        FeatureIterator it = fc.features();
        SimpleFeature feature = null;
        while (it.hasNext()) {
            SimpleFeature feat = (SimpleFeature)it.next();
            if (!feat.getID().equals(this.shape.getEditGeom().getFeatureIDRef().toString())) continue;
            feature = feat;
            break;
        }
        it.close();
        this.oldFeature = this.getMap().getEditManagerInternal().getEditFeature();
        this.oldLayer = this.getMap().getEditManagerInternal().getEditLayer();
        this.editLayer = (Layer)this.handler.getEditLayer();
        this.oldFilter = this.editLayer.getFilter();
        this.getMap().getEditManagerInternal().setEditFeature(feature, this.editLayer);
        this.editLayer.setFilter(this.fidFilter(feature));
    }

    private Filter fidFilter(SimpleFeature feature) {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        Id id = factory.id(Collections.singleton(factory.featureId(feature.getID())));
        return id;
    }

    public String getName() {
        return "Set Current Selection";
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        this.getMap().getEditManagerInternal().setEditFeature(this.oldFeature, (Layer)this.oldLayer);
        this.editLayer.setFilter(this.oldFilter);
    }
}

