/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import java.awt.geom.GeneralPath;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.PostDeterminedEffectCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import net.refractions.udig.tools.edit.support.PrimitiveShapeIterator;
import org.eclipse.core.runtime.IProgressMonitor;

public class SelectHoleCommand
extends AbstractCommand
implements UndoableMapCommand,
PostDeterminedEffectCommand {
    private MapMouseEvent event;
    private EditToolHandler handler;
    private PrimitiveShape currentShape;

    public SelectHoleCommand(EditToolHandler handler, MapMouseEvent e) {
        this.handler = handler;
        this.event = e;
    }

    public String getName() {
        return "Select Hole";
    }

    public void run(IProgressMonitor monitor) throws Exception {
        this.execute(monitor);
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        this.handler.setCurrentShape(this.currentShape);
    }

    public boolean execute(IProgressMonitor monitor) throws Exception {
        this.currentShape = this.handler.getCurrentShape();
        if (this.currentShape == null) {
            return false;
        }
        for (PrimitiveShape shape : this.currentShape.getEditGeom()) {
            if (shape == this.currentShape || this.currentShape.getEditGeom().getShell() == shape) continue;
            GeneralPath path = new GeneralPath();
            path.append(PrimitiveShapeIterator.getPathIterator(shape), false);
            if (!path.contains(this.event.x, this.event.y)) continue;
            this.handler.setCurrentShape(shape);
            break;
        }
        return true;
    }
}

