/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.ui.AnimationUpdater;
import net.refractions.udig.project.ui.IAnimation;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.tool.IToolContext;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.commands.BlockingSelectionAnim;
import net.refractions.udig.tools.edit.commands.DeselectionStrategy;
import net.refractions.udig.tools.edit.commands.SelectionParameter;
import net.refractions.udig.tools.edit.commands.SelectionStrategy;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;

public class SelectFeaturesAtPointCommand
extends AbstractCommand
implements UndoableMapCommand {
    private static final int SEARCH_SIZE = 7;
    private EditToolHandler handler;
    private final Set<Class<? extends Geometry>> acceptableClasses = new HashSet<Class<? extends Geometry>>();
    private MapMouseEvent event;
    private Class<? extends Filter> filterType;
    private UndoableMapCommand command;
    private final SelectionParameter parameters;
    boolean warned = false;

    public SelectFeaturesAtPointCommand(SelectionParameter parameterObject) {
        this.parameters = parameterObject;
        this.handler = parameterObject.handler;
        this.event = parameterObject.event;
        this.acceptableClasses.addAll(Arrays.asList(parameterObject.acceptableClasses));
        this.filterType = parameterObject.filterType;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        if (this.command != null) {
            this.command.run(monitor);
        } else {
            IToolContext context = this.handler.getContext();
            ILayer editLayer = this.handler.getEditLayer();
            EditBlackboard editBlackboard = this.handler.getEditBlackboard(editLayer);
            editBlackboard.startBatchingEvents();
            BlockingSelectionAnim animation = new BlockingSelectionAnim(this.event.x, this.event.y);
            AnimationUpdater.runTimer((IMapDisplay)context.getMapDisplay(), (IAnimation)animation);
            FeatureIterator<SimpleFeature> iter = this.getFeatureIterator();
            try {
                if (iter.hasNext()) {
                    this.runSelectionStrategies(monitor, iter);
                } else {
                    this.runDeselectionStrategies(monitor);
                }
                this.setAndRun(monitor, this.command);
            }
            finally {
                try {
                    if (iter != null) {
                        iter.close();
                    }
                }
                finally {
                    if (animation != null) {
                        animation.setValid(false);
                        animation = null;
                    }
                }
                editBlackboard.fireBatchedEvents();
            }
        }
    }

    private FeatureIterator<SimpleFeature> getFeatureIterator() throws IOException {
        ILayer editLayer = this.parameters.handler.getEditLayer();
        FeatureStore<SimpleFeatureType, SimpleFeature> store = this.getResource(editLayer);
        ReferencedEnvelope bbox = this.handler.getContext().getBoundingBox(this.event.getPoint(), 7);
        try {
            bbox = bbox.transform(this.parameters.handler.getEditLayer().getCRS(), true);
        }
        catch (TransformException e) {
            this.logTransformationWarning((Exception)((Object)e));
        }
        catch (FactoryException e) {
            this.logTransformationWarning((Exception)((Object)e));
        }
        Filter createBBoxFilter = this.createBBoxFilter(bbox, editLayer, this.filterType);
        FeatureCollection collection = store.getFeatures(createBBoxFilter);
        IntersectTestingIterator reader = new IntersectTestingIterator(bbox, (FeatureIterator<SimpleFeature>)collection.features());
        return reader;
    }

    private FeatureStore<SimpleFeatureType, SimpleFeature> getResource(ILayer editLayer) throws IOException {
        FeatureStore store = (FeatureStore)editLayer.getResource(FeatureStore.class, null);
        return store;
    }

    private void runDeselectionStrategies(IProgressMonitor monitor) {
        List<DeselectionStrategy> strategies = this.parameters.deselectionStrategies;
        UndoableComposite compositeCommand = new UndoableComposite();
        for (DeselectionStrategy strategy : strategies) {
            strategy.run(monitor, this.parameters, compositeCommand);
        }
        this.command = compositeCommand;
    }

    private void runSelectionStrategies(IProgressMonitor monitor, FeatureIterator<SimpleFeature> reader) {
        List<SelectionStrategy> strategies = this.parameters.selectionStrategies;
        UndoableComposite compositeCommand = new UndoableComposite();
        compositeCommand.setName(Messages.SelectGeometryCommand_name);
        SimpleFeature firstFeature = (SimpleFeature)reader.next();
        for (SelectionStrategy selectionStrategy : strategies) {
            selectionStrategy.run(monitor, compositeCommand, this.parameters, firstFeature, true);
        }
        while (reader.hasNext()) {
            SimpleFeature nextFeature = (SimpleFeature)reader.next();
            for (SelectionStrategy selectionStrategy : strategies) {
                selectionStrategy.run(monitor, compositeCommand, this.parameters, nextFeature, false);
            }
        }
        this.command = compositeCommand;
    }

    private void logTransformationWarning(Exception e) {
        if (!this.warned) {
            EditPlugin.log("Error transforming bbox from viewportmodel CRS to LayerCRS", e);
        }
    }

    public Filter createBBoxFilter(ReferencedEnvelope boundingBox, ILayer layer, Class<? extends Filter> filterType) {
        FilterFactory2 factory = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        if (!layer.hasResource(FeatureSource.class)) {
            return Filter.EXCLUDE;
        }
        try {
            SimpleFeatureType schema = layer.getSchema();
            Name geom = SelectFeaturesAtPointCommand.getGeometryAttDescriptor(schema).getName();
            BBOX bboxFilter = factory.bbox((Expression)factory.property(geom), (BoundingBox)boundingBox);
            return bboxFilter;
        }
        catch (Exception e) {
            ProjectPlugin.getPlugin().log((Object)e);
            return Filter.EXCLUDE;
        }
    }

    private void setAndRun(IProgressMonitor monitor, UndoableMapCommand undoableComposite) throws Exception {
        undoableComposite.setMap((IMap)this.getMap());
        undoableComposite.run(monitor);
    }

    public String getName() {
        return Messages.SelectGeometryCommand_name;
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        this.command.rollback(monitor);
    }

    private static GeometryDescriptor getGeometryAttDescriptor(SimpleFeatureType schema) {
        return schema.getGeometryDescriptor();
    }

    private static class IntersectTestingIterator
    implements FeatureIterator<SimpleFeature> {
        private final FeatureIterator<SimpleFeature> wrappedIter;
        private final ReferencedEnvelope bbox;
        private SimpleFeature next;

        public IntersectTestingIterator(ReferencedEnvelope bbox, FeatureIterator<SimpleFeature> wrapped) {
            this.wrappedIter = wrapped;
            this.bbox = bbox;
        }

        public void close() {
            this.wrappedIter.close();
        }

        /*
         * Unable to fully structure code
         */
        public boolean hasNext() {
            if (this.next == null) ** GOTO lbl6
            return true;
lbl-1000:
            // 1 sources

            {
                feature = (SimpleFeature)this.wrappedIter.next();
                if (!this.intersects(feature)) continue;
                this.next = feature;
lbl6:
                // 3 sources

                ** while (this.wrappedIter.hasNext() && this.next == null)
            }
lbl7:
            // 1 sources

            return this.next != null;
        }

        private boolean intersects(SimpleFeature feature) {
            GeometryDescriptor geomDescriptor = SelectFeaturesAtPointCommand.getGeometryAttDescriptor(feature.getFeatureType());
            Geometry bboxGeom = new GeometryFactory().toGeometry((Envelope)this.bbox);
            Geometry geom = (Geometry)feature.getAttribute(geomDescriptor.getName());
            try {
                return geom.intersects(bboxGeom);
            }
            catch (Exception e) {
                EditPlugin.log("Can't do intersection so I'm assuming they intersect", e);
                return false;
            }
        }

        public SimpleFeature next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            SimpleFeature f = this.next;
            this.next = null;
            return f;
        }
    }
}

