/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.util.Collection;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.commands.SetEditFeatureCommand;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.EditUtils;
import net.refractions.udig.tools.edit.support.Point;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;

public class SelectFeatureCommand
extends AbstractCommand
implements UndoableMapCommand {
    private Collection<EditGeom> added;
    private SimpleFeature feature;
    private EditBlackboard blackboard;
    private Layer editLayer;
    private ReferencedEnvelope refreshBounds;
    private EditToolHandler handler;
    private Point mouseLocation;
    private SetEditFeatureCommand setEditFeatureCommand;

    public SelectFeatureCommand(EditToolHandler handler, SimpleFeature feature, Point mouseLocation) {
        this.feature = feature;
        this.editLayer = (Layer)handler.getEditLayer();
        this.blackboard = handler.getEditBlackboard((ILayer)this.editLayer);
        this.handler = handler;
        this.mouseLocation = mouseLocation;
    }

    public SelectFeatureCommand(EditBlackboard blackboard2, SimpleFeature feature2) {
        this.feature = feature2;
        this.blackboard = blackboard2;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        if (this.editLayer == null) {
            this.editLayer = (Layer)this.getMap().getEditManager().getSelectedLayer();
        }
        this.added = this.blackboard.addGeometry((Geometry)this.feature.getDefaultGeometry(), this.feature.getID()).values();
        if (!this.added.isEmpty() && this.mouseLocation != null) {
            Class type = this.editLayer.getSchema().getGeometryDescriptor().getType().getBinding();
            boolean polygonLayer = Polygon.class.isAssignableFrom(type) || MultiPolygon.class.isAssignableFrom(type);
            EditGeom geom = EditUtils.instance.getGeomWithMouseOver(this.added, this.mouseLocation, polygonLayer);
            this.handler.setCurrentShape(geom.getShell());
            this.setEditFeatureCommand = new SetEditFeatureCommand(this.handler, this.mouseLocation, geom.getShell());
            this.setEditFeatureCommand.setMap((IMap)this.getMap());
            this.setEditFeatureCommand.run((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
        }
        this.refreshBounds = new ReferencedEnvelope(this.feature.getBounds());
        EditUtils.instance.refreshLayer((ILayer)this.editLayer, this.feature, (Envelope)this.refreshBounds, false, true);
    }

    public String getName() {
        return Messages.AddGeomCommand_name;
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        if (this.setEditFeatureCommand != null) {
            this.setEditFeatureCommand.rollback((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
        }
        this.blackboard.removeGeometries(this.added);
        this.refreshBounds.expandToInclude((Envelope)new ReferencedEnvelope(this.feature.getBounds()));
        EditUtils.instance.refreshLayer((ILayer)this.editLayer, this.feature, (Envelope)this.refreshBounds, true, false);
    }
}

