/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.tool.IToolContext;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.EditUtils;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;

public class SelectFeatureAsEditFeatureCommand
extends AbstractCommand
implements Command,
UndoableMapCommand {
    private ILayer selectedLayer;
    private SimpleFeature feature;
    private EditToolHandler handler;
    private UndoableMapCommand unselectcommand;
    private UndoableMapCommand command;
    private List<EditGeom> removed;
    private EditGeom currentGeom;
    private PrimitiveShape currentShape;
    private EditState currentState;
    private Point mouse;
    private ReferencedEnvelope refreshBounds;

    public SelectFeatureAsEditFeatureCommand(EditToolHandler handler, SimpleFeature feature, ILayer selectedLayer, Point mouse) {
        if (mouse == null) {
            throw new NullPointerException("mouse is null");
        }
        this.handler = handler;
        this.feature = feature;
        this.selectedLayer = selectedLayer;
        this.mouse = mouse;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(Messages.SetGeomCommand_undoTask, 30);
        EditUtils.instance.cancelHideSelection(this.selectedLayer);
        IToolContext context = this.handler.getContext();
        this.refreshBounds = new ReferencedEnvelope(this.feature.getBounds());
        EditUtils.instance.refreshLayer(this.selectedLayer, this.feature, (Envelope)this.refreshBounds, false, true);
        this.unselectcommand = context.getSelectionFactory().createNoSelectCommand();
        this.command = context.getEditFactory().createSetEditFeatureCommand(this.feature, this.selectedLayer);
        this.unselectcommand.setMap((IMap)this.getMap());
        this.command.setMap((IMap)this.getMap());
        this.unselectcommand.run((IProgressMonitor)new SubProgressMonitor(monitor, 10));
        this.command.run((IProgressMonitor)new SubProgressMonitor(monitor, 10));
        this.removed = this.handler.getEditBlackboard(this.selectedLayer).getGeoms();
        this.currentGeom = this.handler.getCurrentGeom();
        this.currentShape = this.handler.getCurrentShape();
        this.currentState = this.handler.getCurrentState();
        this.handler.setCurrentState(EditState.MODIFYING);
        Collection<EditGeom> geoms = this.handler.getEditBlackboard(this.selectedLayer).setGeometries((Geometry)this.feature.getDefaultGeometry(), this.feature.getID()).values();
        Class type = this.selectedLayer.getSchema().getGeometryDescriptor().getType().getBinding();
        boolean polygonLayer = Polygon.class.isAssignableFrom(type) || MultiPolygon.class.isAssignableFrom(type);
        EditGeom over = EditUtils.instance.getGeomWithMouseOver(geoms, this.mouse, polygonLayer);
        this.handler.setCurrentShape(over.getShell());
        monitor.done();
    }

    public String getName() {
        return Messages.SetGeomCommand_name;
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(Messages.SetGeomCommand_runTask, 30);
        this.handler.setCurrentShape(this.currentShape);
        EditBlackboard bb = this.handler.getEditBlackboard(this.selectedLayer);
        this.handler.setCurrentState(this.currentState);
        EditGeom newCurrentGeom = null;
        List<EditGeom> empty = bb.getGeoms();
        for (EditGeom original : this.removed) {
            EditGeom inBlackboard = bb.newGeom(original.getFeatureIDRef().get(), original.getShapeType());
            inBlackboard.setChanged(original.isChanged());
            if (original == this.currentGeom) {
                newCurrentGeom = inBlackboard;
            }
            PrimitiveShape destination = inBlackboard.getShell();
            newCurrentGeom = this.setCurrentGeom(newCurrentGeom, destination, original.getShell());
            Iterator<Coordinate> iter = original.getShell().coordIterator();
            while (iter.hasNext()) {
                bb.addCoordinate(iter.next(), destination);
            }
            for (PrimitiveShape shape : original.getHoles()) {
                destination = inBlackboard.newHole();
                newCurrentGeom = this.setCurrentGeom(newCurrentGeom, destination, shape);
                Iterator<Coordinate> iter2 = shape.coordIterator();
                while (iter2.hasNext()) {
                    bb.addCoordinate(iter2.next(), destination);
                }
            }
        }
        bb.removeGeometries(empty);
        monitor.worked(10);
        this.refreshBounds.expandToInclude((Envelope)new ReferencedEnvelope(this.feature.getBounds()));
        EditUtils.instance.refreshLayer(this.selectedLayer, this.feature, (Envelope)this.refreshBounds, true, false);
        this.command.rollback((IProgressMonitor)new SubProgressMonitor(monitor, 10));
        this.unselectcommand.rollback((IProgressMonitor)new SubProgressMonitor(monitor, 10));
    }

    private EditGeom setCurrentGeom(EditGeom newCurrentGeom, PrimitiveShape destination, PrimitiveShape shape) {
        if (this.currentGeom != null && newCurrentGeom != null && shape == this.currentShape) {
            this.handler.setCurrentShape(destination);
        }
        return newCurrentGeom;
    }
}

