/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import org.eclipse.core.runtime.IProgressMonitor;

public class RemoveAllVerticesCommand
extends AbstractCommand
implements UndoableMapCommand {
    private EditToolHandler handler;
    private EditGeom oldGeom;

    public RemoveAllVerticesCommand(EditToolHandler handler) {
        this.handler = handler;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        EditGeom geom = this.handler.getCurrentGeom();
        this.oldGeom = new EditGeom(geom);
        for (Point point : geom.getShell()) {
            geom.getEditBlackboard().removeCoords(point.getX(), point.getY(), geom.getShell());
        }
    }

    public String getName() {
        return "RemoveAllVerticesCommand";
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        EditBlackboard bb = this.oldGeom.getEditBlackboard();
        EditGeom geom = bb.newGeom(this.oldGeom.getFeatureIDRef().get(), this.oldGeom.getShapeType());
        for (Point p : this.oldGeom.getShell()) {
            bb.addPoint(p.getX(), p.getY(), geom.getShell());
        }
        for (PrimitiveShape shape : this.oldGeom.getHoles()) {
            PrimitiveShape hole = geom.newHole();
            for (Point p : shape) {
                bb.addPoint(p.getX(), p.getY(), hole);
            }
        }
    }
}

